/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.spatial.ImmutableFloatPoint;
import org.apache.druid.collections.spatial.ImmutableNode;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.segment.incremental.SpatialDimensionRowTransformer;

public class RectangularBound
implements Bound<float[], ImmutableFloatPoint> {
    private static final byte CACHE_TYPE_ID = 0;
    private final float[] minCoords;
    private final float[] maxCoords;
    private final int limit;
    private final int numDims;

    @JsonCreator
    public RectangularBound(@JsonProperty(value="minCoords") float[] minCoords, @JsonProperty(value="maxCoords") float[] maxCoords, @JsonProperty(value="limit") int limit) {
        Preconditions.checkArgument((minCoords.length == maxCoords.length ? 1 : 0) != 0);
        this.numDims = minCoords.length;
        this.minCoords = minCoords;
        this.maxCoords = maxCoords;
        this.limit = limit;
    }

    public RectangularBound(float[] minCoords, float[] maxCoords) {
        this(minCoords, maxCoords, 0);
    }

    @JsonProperty
    public float[] getMinCoords() {
        return this.minCoords;
    }

    @JsonProperty
    public float[] getMaxCoords() {
        return this.maxCoords;
    }

    @Override
    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getNumDims() {
        return this.numDims;
    }

    @Override
    public boolean overlaps(ImmutableNode<float[]> node) {
        float[] nodeMinCoords = node.getMinCoordinates();
        float[] nodeMaxCoords = node.getMaxCoordinates();
        for (int i = 0; i < this.numDims; ++i) {
            if (!(nodeMaxCoords[i] < this.minCoords[i]) && !(nodeMinCoords[i] > this.maxCoords[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(float[] coords) {
        for (int i = 0; i < this.numDims; ++i) {
            if (!(coords[i] < this.minCoords[i]) && !(coords[i] > this.maxCoords[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsObj(@Nullable Object input) {
        if (input instanceof String) {
            float[] coordinate = SpatialDimensionRowTransformer.decode((String)input);
            if (coordinate == null) {
                return false;
            }
            return this.contains(coordinate);
        }
        return false;
    }

    @Override
    public Iterable<ImmutableFloatPoint> filter(Iterable<ImmutableFloatPoint> points) {
        return Iterables.filter(points, (Predicate)new Predicate<ImmutableFloatPoint>(){

            public boolean apply(ImmutableFloatPoint immutablePoint) {
                return RectangularBound.this.contains(immutablePoint.getCoords());
            }
        });
    }

    @Override
    public byte[] getCacheKey() {
        ByteBuffer minCoordsBuffer = ByteBuffer.allocate(this.minCoords.length * 4);
        minCoordsBuffer.asFloatBuffer().put(this.minCoords);
        byte[] minCoordsCacheKey = minCoordsBuffer.array();
        ByteBuffer maxCoordsBuffer = ByteBuffer.allocate(this.maxCoords.length * 4);
        maxCoordsBuffer.asFloatBuffer().put(this.maxCoords);
        byte[] maxCoordsCacheKey = maxCoordsBuffer.array();
        ByteBuffer cacheKey = ByteBuffer.allocate(1 + minCoordsCacheKey.length + maxCoordsCacheKey.length + 4).put(minCoordsCacheKey).put(maxCoordsCacheKey).putInt(this.limit).put((byte)0);
        return cacheKey.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RectangularBound that = (RectangularBound)o;
        return this.limit == that.limit && this.numDims == that.numDims && Arrays.equals(this.minCoords, that.minCoords) && Arrays.equals(this.maxCoords, that.maxCoords);
    }

    public int hashCode() {
        int result = Objects.hash(this.limit, this.numDims);
        result = 31 * result + Arrays.hashCode(this.minCoords);
        result = 31 * result + Arrays.hashCode(this.maxCoords);
        return result;
    }
}

