/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.druid.java.util.common.concurrent.Execs;

public class FutureBox
implements Closeable {
    private final Set<ListenableFuture<?>> pendingFutures = Sets.newConcurrentHashSet();
    private volatile boolean stopped;

    public int pendingCount() {
        return this.pendingFutures.size();
    }

    public <R> ListenableFuture<R> register(ListenableFuture<R> future) {
        this.pendingFutures.add(future);
        future.addListener(() -> this.pendingFutures.remove(future), (Executor)Execs.directExecutor());
        if (this.stopped) {
            future.cancel(false);
        }
        return future;
    }

    @Override
    public void close() {
        this.stopped = true;
        for (ListenableFuture<?> future : this.pendingFutures) {
            future.cancel(false);
        }
    }
}

