/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.TextReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.ParserUtils;
import org.apache.druid.segment.column.RowSignature;

public class DelimitedValueReader
extends TextReader.Bytes {
    private final boolean findColumnsFromHeader;
    private final int skipHeaderRows;
    private final Function<String, Object> multiValueFunction;
    private final DelimitedValueParser parser;
    @Nullable
    private RowSignature inputRowSignature;
    @Nullable
    private List<String> inputRowDimensions;
    private final boolean useListBasedInputRows;

    DelimitedValueReader(InputRowSchema inputRowSchema, InputEntity source, @Nullable String listDelimiter, @Nullable List<String> columns, boolean findColumnsFromHeader, int skipHeaderRows, DelimitedValueParser parser, boolean useListBasedInputRows) {
        super(inputRowSchema, source);
        this.findColumnsFromHeader = findColumnsFromHeader;
        this.skipHeaderRows = skipHeaderRows;
        String finalListDelimeter = listDelimiter == null ? "\u0001" : listDelimiter;
        this.multiValueFunction = ParserUtils.getMultiValueFunction(finalListDelimeter, Splitter.on((String)finalListDelimeter));
        if (!findColumnsFromHeader && columns != null) {
            this.setSignature(columns);
        }
        this.parser = parser;
        this.useListBasedInputRows = useListBasedInputRows;
    }

    @Override
    public List<InputRow> parseInputRows(byte[] line) throws IOException, ParseException {
        if (this.useListBasedInputRows) {
            List<Object> parsed = this.readLineAsList(line);
            return Collections.singletonList(ListBasedInputRow.parse(this.inputRowSignature, this.getInputRowSchema().getTimestampSpec(), this.inputRowDimensions, parsed));
        }
        Map<String, Object> zipped = this.readLineAsMap(line);
        return Collections.singletonList(MapInputRowParser.parse(this.getInputRowSchema().getTimestampSpec(), this.inputRowDimensions, zipped));
    }

    @Override
    public List<Map<String, Object>> toMap(byte[] intermediateRow) throws IOException {
        return Collections.singletonList(this.readLineAsMap(intermediateRow));
    }

    private List<Object> readLineAsList(byte[] line) throws IOException {
        List<String> parsed = this.parser.parseLine(line);
        return new ArrayList<Object>(Lists.transform(parsed, this.multiValueFunction));
    }

    private Map<String, Object> readLineAsMap(byte[] line) throws IOException {
        List<String> parsed = this.parser.parseLine(line);
        return Utils.zipMapPartial(((RowSignature)Preconditions.checkNotNull((Object)this.inputRowSignature, (Object)"inputRowSignature")).getColumnNames(), Iterables.transform(parsed, this.multiValueFunction));
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return this.skipHeaderRows;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return this.findColumnsFromHeader;
    }

    @Override
    public void processHeaderLine(byte[] line) throws IOException {
        if (!this.findColumnsFromHeader) {
            throw new ISE("Don't call this if findColumnsFromHeader = false", new Object[0]);
        }
        this.setSignature(this.parser.parseLine(line));
    }

    private void setSignature(List<String> columns) {
        this.inputRowSignature = DelimitedValueReader.findOrCreateInputRowSignature(columns);
        if (this.inputRowSignature.size() == 0) {
            throw new ISE("Empty columns", new Object[0]);
        }
        this.inputRowDimensions = MapInputRowParser.findDimensions(this.getInputRowSchema().getTimestampSpec(), this.getInputRowSchema().getDimensionsSpec(), (Set<String>)ImmutableSet.copyOf(this.inputRowSignature.getColumnNames()));
    }

    static interface DelimitedValueParser {
        public List<String> parseLine(byte[] var1) throws IOException;
    }
}

