/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.data.input.BytesCountingInputEntity;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.RowAdapter;

public class InputEntityIteratingReader
implements InputSourceReader {
    private final InputRowSchema inputRowSchema;
    private final InputFormat inputFormat;
    private final CloseableIterator<InputEntity> sourceIterator;
    private final SystemFieldDecoratorFactory systemFieldDecoratorFactory;
    private final File temporaryDirectory;

    public InputEntityIteratingReader(InputRowSchema inputRowSchema, InputFormat inputFormat, CloseableIterator<? extends InputEntity> sourceIterator, SystemFieldDecoratorFactory systemFieldDecoratorFactory, File temporaryDirectory) {
        this.inputRowSchema = inputRowSchema;
        this.inputFormat = inputFormat;
        this.sourceIterator = sourceIterator;
        this.systemFieldDecoratorFactory = systemFieldDecoratorFactory;
        this.temporaryDirectory = temporaryDirectory;
    }

    @Override
    public CloseableIterator<InputRow> read(InputStats inputStats) {
        return this.createIterator(entity -> {
            Function<InputRow, InputRow> systemFieldDecorator = this.systemFieldDecoratorFactory.decorator((InputEntity)entity);
            try {
                InputEntity entityToRead = inputStats == null ? entity : new BytesCountingInputEntity((InputEntity)entity, inputStats);
                InputEntityReader reader = this.inputFormat.createReader(this.inputRowSchema, entityToRead, this.temporaryDirectory);
                return reader.read().map(systemFieldDecorator);
            }
            catch (IOException e) {
                throw new RuntimeException(entity.getUri() != null ? "Error occurred while trying to read uri: " + entity.getUri() : "Error occurred while reading input", e);
            }
        });
    }

    @Override
    public CloseableIterator<InputRowListPlusRawValues> sample() {
        return this.createIterator(entity -> {
            Function<InputRow, InputRow> systemFieldDecorator = this.systemFieldDecoratorFactory.decorator((InputEntity)entity);
            try {
                InputEntityReader reader = this.inputFormat.createReader(this.inputRowSchema, (InputEntity)entity, this.temporaryDirectory);
                return reader.sample().map(i -> InputRowListPlusRawValues.ofList(i.getRawValuesList(), i.getInputRows() == null ? null : i.getInputRows().stream().map(systemFieldDecorator).collect(Collectors.toList()), i.getParseException()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public RowAdapter<InputRow> rowAdapter() {
        return this.inputFormat.createRowAdapter(this.inputRowSchema);
    }

    private <R> CloseableIterator<R> createIterator(Function<InputEntity, CloseableIterator<R>> rowPopulator) {
        return this.sourceIterator.flatMap(rowPopulator);
    }
}

