/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.parsers.TimestampParser;
import org.joda.time.DateTime;

public class TimestampSpec {
    public static final String DEFAULT_COLUMN = "timestamp";
    private static final String DEFAULT_FORMAT = "auto";
    private static final DateTime DEFAULT_MISSING_VALUE = null;
    private final String timestampColumn;
    private final String timestampFormat;
    private final DateTime missingValue;
    private final Function<Object, DateTime> timestampConverter;
    private static final ThreadLocal<ParseCtx> PARSE_CTX = ThreadLocal.withInitial(() -> new ParseCtx());

    @JsonCreator
    public TimestampSpec(@JsonProperty(value="column") @Nullable String timestampColumn, @JsonProperty(value="format") @Nullable String format, @JsonProperty(value="missingValue") @Nullable DateTime missingValue) {
        this.timestampColumn = timestampColumn == null ? DEFAULT_COLUMN : timestampColumn;
        this.timestampFormat = format == null ? DEFAULT_FORMAT : format;
        this.timestampConverter = TimestampParser.createObjectTimestampParser(this.timestampFormat);
        this.missingValue = missingValue == null ? DEFAULT_MISSING_VALUE : missingValue;
    }

    @JsonProperty(value="column")
    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    @JsonProperty(value="format")
    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    @JsonProperty(value="missingValue")
    public DateTime getMissingValue() {
        return this.missingValue;
    }

    @Nullable
    public DateTime extractTimestamp(@Nullable Map<String, Object> input) {
        return this.parseDateTime(this.getRawTimestamp(input));
    }

    @Nullable
    public Object getRawTimestamp(@Nullable Map<String, Object> input) {
        return input == null ? null : input.get(this.timestampColumn);
    }

    @Nullable
    public DateTime parseDateTime(@Nullable Object input) {
        DateTime extracted = this.missingValue;
        if (input != null) {
            ParseCtx ctx = PARSE_CTX.get();
            if (input.equals(ctx.lastTimeObject)) {
                extracted = ctx.lastDateTime;
            } else {
                extracted = (DateTime)this.timestampConverter.apply(input);
                ParseCtx newCtx = new ParseCtx();
                newCtx.lastTimeObject = input;
                newCtx.lastDateTime = extracted;
                PARSE_CTX.set(newCtx);
            }
        }
        return extracted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampSpec that = (TimestampSpec)o;
        if (!this.timestampColumn.equals(that.timestampColumn)) {
            return false;
        }
        if (!this.timestampFormat.equals(that.timestampFormat)) {
            return false;
        }
        return !(this.missingValue == null ? that.missingValue != null : !this.missingValue.equals((Object)that.missingValue));
    }

    public int hashCode() {
        int result = this.timestampColumn.hashCode();
        result = 31 * result + this.timestampFormat.hashCode();
        result = 31 * result + (this.missingValue != null ? this.missingValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TimestampSpec{timestampColumn='" + this.timestampColumn + '\'' + ", timestampFormat='" + this.timestampFormat + '\'' + ", missingValue=" + this.missingValue + '}';
    }

    public static TimestampSpec mergeTimestampSpec(List<TimestampSpec> toMerge) {
        if (toMerge == null || toMerge.size() == 0) {
            return null;
        }
        TimestampSpec result = toMerge.get(0);
        for (int i = 1; i < toMerge.size(); ++i) {
            if (toMerge.get(i) == null || Objects.equals(result, toMerge.get(i))) continue;
            return null;
        }
        return result;
    }

    private static class ParseCtx {
        Object lastTimeObject = null;
        DateTime lastDateTime = null;

        private ParseCtx() {
        }
    }
}

