/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.DoubleFieldWriter;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.FloatFieldWriter;
import org.apache.druid.frame.field.LongFieldWriter;
import org.apache.druid.frame.field.NumericFieldWriter;
import org.apache.druid.frame.field.NumericFieldWriterFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class NumericArrayFieldWriter
implements FieldWriter {
    public static final byte NULL_ROW = 0;
    public static final byte NON_NULL_ROW = 1;
    public static final byte ARRAY_TERMINATOR = 0;
    private final ColumnValueSelector selector;
    private final NumericFieldWriterFactory writerFactory;

    public static NumericArrayFieldWriter getLongArrayFieldWriter(ColumnValueSelector selector) {
        return new NumericArrayFieldWriter(selector, LongFieldWriter::forArray);
    }

    public static NumericArrayFieldWriter getFloatArrayFieldWriter(ColumnValueSelector selector) {
        return new NumericArrayFieldWriter(selector, FloatFieldWriter::forArray);
    }

    public static NumericArrayFieldWriter getDoubleArrayFieldWriter(ColumnValueSelector selector) {
        return new NumericArrayFieldWriter(selector, DoubleFieldWriter::forArray);
    }

    public NumericArrayFieldWriter(ColumnValueSelector selector, NumericFieldWriterFactory writerFactory) {
        this.selector = selector;
        this.writerFactory = writerFactory;
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        final Object[] row = (Object[])this.selector.getObject();
        if (row == null) {
            int requiredSize = 1;
            if ((long)requiredSize > maxSize) {
                return -1L;
            }
            memory.putByte(position, (byte)0);
            return requiredSize;
        }
        final AtomicInteger index = new AtomicInteger(0);
        ColumnValueSelector<Number> columnValueSelector = new ColumnValueSelector<Number>(){

            @Override
            public double getDouble() {
                Number n = this.getObject();
                assert (NullHandling.replaceWithDefault() || n != null);
                return n != null ? n.doubleValue() : 0.0;
            }

            @Override
            public float getFloat() {
                Number n = this.getObject();
                assert (NullHandling.replaceWithDefault() || n != null);
                return n != null ? n.floatValue() : 0.0f;
            }

            @Override
            public long getLong() {
                Number n = this.getObject();
                assert (NullHandling.replaceWithDefault() || n != null);
                return n != null ? n.longValue() : 0L;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            public boolean isNull() {
                return this.getObject() == null;
            }

            @Override
            @Nullable
            public Number getObject() {
                return (Number)row[index.get()];
            }

            @Override
            public Class<? extends Number> classOfObject() {
                return Number.class;
            }
        };
        NumericFieldWriter writer = this.writerFactory.get(columnValueSelector);
        int requiredSize = 1 + (writer.getNumericSizeBytes() + 1) * row.length + 1;
        if ((long)requiredSize > maxSize) {
            return -1L;
        }
        long offset = 0L;
        memory.putByte(position + offset, (byte)1);
        ++offset;
        while (index.get() < row.length) {
            writer.writeTo(memory, position + offset, maxSize - offset);
            offset += (long)(1 + writer.getNumericSizeBytes());
            index.incrementAndGet();
        }
        memory.putByte(position + offset, (byte)0);
        return requiredSize;
    }

    @Override
    public void close() {
    }
}

