/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.math.LongMath;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.NumericArrayFrameColumnReader;
import org.apache.druid.segment.column.ColumnType;

public class FloatArrayFrameColumnReader
extends NumericArrayFrameColumnReader {
    public FloatArrayFrameColumnReader(int columnNumber) {
        super((byte)8, ColumnType.FLOAT_ARRAY, columnNumber);
    }

    @Override
    NumericArrayFrameColumnReader.NumericArrayFrameColumn column(Frame frame, Memory memory, ColumnType columnType) {
        return new FloatArrayFrameColumn(frame, memory, columnType);
    }

    private static class FloatArrayFrameColumn
    extends NumericArrayFrameColumnReader.NumericArrayFrameColumn {
        public FloatArrayFrameColumn(Frame frame, Memory memory, ColumnType columnType) {
            super(frame, memory, columnType);
        }

        @Override
        Number getElement(Memory memory, long rowDataOffset, int cumulativeIndex) {
            return Float.valueOf(memory.getFloat(LongMath.checkedAdd((long)rowDataOffset, (long)((long)cumulativeIndex * 4L))));
        }
    }
}

