/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHolder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class InputStreamFullResponseHandler
implements HttpResponseHandler<InputStreamFullResponseHolder, InputStreamFullResponseHolder> {
    @Override
    public ClientResponse<InputStreamFullResponseHolder> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        InputStreamFullResponseHolder holder = new InputStreamFullResponseHolder(response);
        holder.addChunk(this.getContentBytes(response.getContent()));
        return ClientResponse.finished(holder);
    }

    @Override
    public ClientResponse<InputStreamFullResponseHolder> handleChunk(ClientResponse<InputStreamFullResponseHolder> clientResponse, HttpChunk chunk, long chunkNum) {
        clientResponse.getObj().addChunk(this.getContentBytes(chunk.getContent()));
        return clientResponse;
    }

    @Override
    public ClientResponse<InputStreamFullResponseHolder> done(ClientResponse<InputStreamFullResponseHolder> clientResponse) {
        InputStreamFullResponseHolder holder = clientResponse.getObj();
        holder.done();
        return ClientResponse.finished(holder);
    }

    @Override
    public void exceptionCaught(ClientResponse<InputStreamFullResponseHolder> clientResponse, Throwable e) {
        clientResponse.getObj().exceptionCaught(e);
    }

    private byte[] getContentBytes(ChannelBuffer content) {
        byte[] contentBytes = new byte[content.readableBytes()];
        content.readBytes(contentBytes);
        return contentBytes;
    }
}

