/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class BivariateLongFunctionVectorValueProcessor<TLeftInput, TRightInput>
implements ExprVectorProcessor<long[]> {
    final ExprVectorProcessor<TLeftInput> left;
    final ExprVectorProcessor<TRightInput> right;
    final boolean[] outNulls;
    final long[] outValues;

    protected BivariateLongFunctionVectorValueProcessor(ExprVectorProcessor<TLeftInput> left, ExprVectorProcessor<TRightInput> right, int maxVectorSize) {
        this.left = left;
        this.right = right;
        this.outValues = new long[maxVectorSize];
        this.outNulls = new boolean[maxVectorSize];
    }

    @Override
    public final ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TLeftInput> lhs = this.left.evalVector(bindings);
        ExprEvalVector<TRightInput> rhs = this.right.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        boolean[] leftNulls = lhs.getNullVector();
        boolean[] rightNulls = rhs.getNullVector();
        boolean hasLeftNulls = leftNulls != null;
        boolean hasRightNulls = rightNulls != null;
        boolean hasNulls = hasLeftNulls || hasRightNulls;
        TLeftInput leftInput = lhs.values();
        TRightInput rightInput = rhs.values();
        if (hasNulls) {
            for (int i = 0; i < currentSize; ++i) {
                boolean bl = this.outNulls[i] = hasLeftNulls && leftNulls[i] || hasRightNulls && rightNulls[i];
                if (!this.outNulls[i]) {
                    this.processIndex(leftInput, rightInput, i);
                    continue;
                }
                this.outValues[i] = 0L;
            }
        } else {
            for (int i = 0; i < currentSize; ++i) {
                this.processIndex(leftInput, rightInput, i);
                this.outNulls[i] = false;
            }
        }
        return this.asEval();
    }

    abstract void processIndex(TLeftInput var1, TRightInput var2, int var3);

    final ExprEvalVector<long[]> asEval() {
        return new ExprEvalLongVector(this.outValues, this.outNulls);
    }
}

