/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.CastToDoubleVectorProcessor;
import org.apache.druid.math.expr.vector.CastToLongVectorProcessor;
import org.apache.druid.math.expr.vector.CastToObjectVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class CastToTypeVectorProcessor<TOutput>
implements ExprVectorProcessor<TOutput> {
    protected final ExprVectorProcessor<?> delegate;

    protected CastToTypeVectorProcessor(ExprVectorProcessor<?> delegate) {
        this.delegate = delegate;
    }

    public static <T> ExprVectorProcessor<T> cast(ExprVectorProcessor<?> castInput, ExpressionType castToType, int maxVectorSize) {
        CastToTypeVectorProcessor caster;
        ExpressionType inputType = castInput.getOutputType();
        if (inputType.equals(castToType)) {
            caster = castInput;
        } else {
            switch ((ExprType)castToType.getType()) {
                case LONG: {
                    caster = new CastToLongVectorProcessor(castInput);
                    break;
                }
                case DOUBLE: {
                    caster = new CastToDoubleVectorProcessor(castInput);
                    break;
                }
                default: {
                    caster = new CastToObjectVectorProcessor(castInput, castToType, maxVectorSize);
                }
            }
        }
        return caster;
    }
}

