/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class UnivariateFunctionVectorObjectProcessor<TInput, TOutput>
implements ExprVectorProcessor<TOutput> {
    final ExprVectorProcessor<TInput> processor;
    final boolean[] outNulls;
    final TOutput outValues;

    public UnivariateFunctionVectorObjectProcessor(ExprVectorProcessor<TInput> processor, int maxVectorSize, TOutput outValues) {
        this.processor = processor;
        this.outNulls = new boolean[maxVectorSize];
        this.outValues = outValues;
    }

    @Override
    public ExprEvalVector<TOutput> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TInput> lhs = this.processor.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        TInput input = lhs.values();
        for (int i = 0; i < currentSize; ++i) {
            this.processIndex(input, this.outValues, this.outNulls, i);
        }
        return this.asEval();
    }

    public abstract void processIndex(TInput var1, TOutput var2, boolean[] var3, int var4);

    public abstract ExprEvalVector<TOutput> asEval();
}

