/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.query.PrioritizedRunnable;

class PrioritizedListenableFutureTask<V>
implements RunnableFuture<V>,
ListenableFuture<V>,
PrioritizedRunnable,
Comparable<PrioritizedListenableFutureTask> {
    private static final Comparator<PrioritizedListenableFutureTask> PRIORITY_COMPARATOR = new Ordering<PrioritizedListenableFutureTask>(){

        public int compare(PrioritizedListenableFutureTask left, PrioritizedListenableFutureTask right) {
            return Integer.compare(right.getPriority(), left.getPriority());
        }
    }.compound((Comparator)new Ordering<PrioritizedListenableFutureTask>(){

        public int compare(PrioritizedListenableFutureTask left, PrioritizedListenableFutureTask right) {
            return Long.compare(right.getInsertionPlace(), left.getInsertionPlace());
        }
    });
    private final ListenableFutureTask<V> delegate;
    private final int priority;
    private final long insertionPlace;

    public static <V> PrioritizedListenableFutureTask<V> create(ListenableFutureTask<V> task, int priority, long position) {
        return new PrioritizedListenableFutureTask<V>(task, priority, position);
    }

    PrioritizedListenableFutureTask(ListenableFutureTask<V> delegate, int priority, long position) {
        this.delegate = delegate;
        this.priority = priority;
        this.insertionPlace = position;
    }

    @Override
    public void run() {
        this.delegate.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.delegate.get(timeout, unit);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected long getInsertionPlace() {
        return this.insertionPlace;
    }

    @Override
    public int compareTo(PrioritizedListenableFutureTask otherTask) {
        return PRIORITY_COMPARATOR.compare(this, otherTask);
    }
}

