/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongMinVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;

    public LongMinVectorAggregator(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        long[] vector = this.selector.getLongVector();
        long min = buf.getLong(position);
        for (int i = startRow; i < endRow; ++i) {
            min = Math.min(min, vector[i]);
        }
        buf.putLong(position, min);
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        long[] vector = this.selector.getLongVector();
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            buf.putLong(position, Math.min(buf.getLong(position), vector[rows != null ? rows[i] : i]));
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public void close() {
    }
}

