/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.serde.cell.IntSerializer;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class SerializedStorage<T> {
    private final WriteOutBytes writeOutBytes;
    private final StagedSerde<T> serde;
    private final IntSerializer intSerializer = new IntSerializer();

    public SerializedStorage(WriteOutBytes writeOutBytes, StagedSerde<T> serde) {
        this.writeOutBytes = writeOutBytes;
        this.serde = serde;
    }

    public void store(@Nullable T value) throws IOException {
        byte[] bytes = this.serde.serialize(value);
        this.writeOutBytes.write(this.intSerializer.serialize(bytes.length));
        this.writeOutBytes.write(bytes);
    }

    public IOIterator<T> iterator() throws IOException {
        return new DeserializingIOIterator<T>(this.writeOutBytes.asInputStream(), this.serde);
    }

    private static class DeserializingIOIterator<T>
    implements IOIterator<T> {
        private static final int NEEDS_READ = -2;
        private static final int EOF = -1;
        private final byte[] intBytes;
        private final BufferedInputStream inputStream;
        private final StagedSerde<T> serde;
        private int nextSize;

        public DeserializingIOIterator(InputStream inputStream, StagedSerde<T> serde) {
            this.inputStream = new BufferedInputStream(inputStream);
            this.serde = serde;
            this.intBytes = new byte[4];
            this.nextSize = -2;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.getNextSize() > -1;
        }

        @Override
        public T next() throws IOException {
            int bytesRead;
            int result;
            int currentNextSize = this.getNextSize();
            if (currentNextSize == -1) {
                throw new NoSuchElementException("end of buffer reached");
            }
            byte[] nextBytes = new byte[currentNextSize];
            for (bytesRead = 0; bytesRead < currentNextSize; bytesRead += result) {
                result = this.inputStream.read(nextBytes, bytesRead, currentNextSize - bytesRead);
                if (result != -1) continue;
                throw new NoSuchElementException("unexpected end of buffer reached");
            }
            Preconditions.checkState((bytesRead == currentNextSize ? 1 : 0) != 0);
            T value = this.serde.deserialize(nextBytes);
            this.nextSize = -2;
            return value;
        }

        private int getNextSize() throws IOException {
            if (this.nextSize == -2) {
                int bytesRead;
                int result;
                for (bytesRead = 0; bytesRead < 4; bytesRead += result) {
                    result = this.inputStream.read(this.intBytes, bytesRead, 4 - bytesRead);
                    if (result != -1) continue;
                    this.nextSize = -1;
                    return -1;
                }
                Preconditions.checkState((bytesRead == 4 ? 1 : 0) != 0);
                this.nextSize = ByteBuffer.wrap(this.intBytes).order(ByteOrder.nativeOrder()).getInt();
            }
            return this.nextSize;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

