/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.mean;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.mean.DoubleMeanHolder;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class DoubleMeanBufferAggregator
implements BufferAggregator {
    private final ColumnValueSelector selector;

    public DoubleMeanBufferAggregator(ColumnValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        DoubleMeanHolder.init(buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.getObject();
        if (update == null && !NullHandling.replaceWithDefault()) {
            return;
        }
        if (update instanceof DoubleMeanHolder) {
            DoubleMeanHolder.update(buf, position, (DoubleMeanHolder)update);
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                DoubleMeanHolder.update(buf, position, Numbers.tryParseDouble(o, 0.0));
            }
        } else {
            DoubleMeanHolder.update(buf, position, Numbers.tryParseDouble(update, 0.0));
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return DoubleMeanHolder.get(buf, position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

