/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.mean;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;

public class DoubleMeanHolder {
    public static final int MAX_INTERMEDIATE_SIZE = 16;
    public static final Comparator<DoubleMeanHolder> COMPARATOR = (o1, o2) -> Doubles.compare((double)o1.mean(), (double)o2.mean());
    private double sum;
    private long count;

    public DoubleMeanHolder(double sum, long count) {
        this.sum = sum;
        this.count = count;
    }

    public void update(double sum) {
        this.sum += sum;
        ++this.count;
    }

    public DoubleMeanHolder update(DoubleMeanHolder other) {
        this.sum += other.sum;
        this.count += other.count;
        return this;
    }

    public double mean() {
        return this.count == 0L ? 0.0 : this.sum / (double)this.count;
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putDouble(0, this.sum);
        buf.putLong(8, this.count);
        return buf.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleMeanHolder that = (DoubleMeanHolder)o;
        return Double.compare(that.sum, this.sum) == 0 && this.count == that.count;
    }

    public int hashCode() {
        return Objects.hash(this.sum, this.count);
    }

    public static DoubleMeanHolder fromBytes(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        return new DoubleMeanHolder(buf.getDouble(0), buf.getLong(8));
    }

    public static void init(ByteBuffer buf, int position) {
        DoubleMeanHolder.writeSum(buf, position, 0.0);
        DoubleMeanHolder.writeCount(buf, position, 0L);
    }

    public static void update(ByteBuffer buf, int position, double sum) {
        DoubleMeanHolder.writeSum(buf, position, DoubleMeanHolder.getSum(buf, position) + sum);
        DoubleMeanHolder.writeCount(buf, position, DoubleMeanHolder.getCount(buf, position) + 1L);
    }

    public static void update(ByteBuffer buf, int position, DoubleMeanHolder other) {
        DoubleMeanHolder.writeSum(buf, position, DoubleMeanHolder.getSum(buf, position) + other.sum);
        DoubleMeanHolder.writeCount(buf, position, DoubleMeanHolder.getCount(buf, position) + other.count);
    }

    public static DoubleMeanHolder get(ByteBuffer buf, int position) {
        return new DoubleMeanHolder(DoubleMeanHolder.getSum(buf, position), DoubleMeanHolder.getCount(buf, position));
    }

    private static void writeSum(ByteBuffer buf, int position, double sum) {
        buf.putDouble(position, sum);
    }

    private static double getSum(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    private static void writeCount(ByteBuffer buf, int position, long count) {
        buf.putLong(position + 8, count);
    }

    private static long getCount(ByteBuffer buf, int position) {
        return buf.getLong(position + 8);
    }

    public static class Serializer
    extends JsonSerializer<DoubleMeanHolder> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void serialize(DoubleMeanHolder obj, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBinary(obj.toBytes());
        }
    }
}

