/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateMatch;

public class FallbackPredicate<T>
implements DruidObjectPredicate<T> {
    private final DruidObjectPredicate<T> delegate;
    private final ExpressionType expectedType;
    private boolean needsCast = false;

    public FallbackPredicate(DruidObjectPredicate<T> delegate, ExpressionType expectedType) {
        this.delegate = delegate;
        this.expectedType = expectedType;
    }

    @Override
    public DruidPredicateMatch apply(@Nullable T input) {
        if (this.needsCast) {
            return this.castApply(input);
        }
        try {
            return this.delegate.apply(input);
        }
        catch (ClassCastException caster) {
            this.needsCast = true;
            return this.castApply(input);
        }
    }

    private DruidPredicateMatch castApply(@Nullable T input) {
        ExprEval castEval = ExprEval.bestEffortOf(input).castTo(this.expectedType);
        return this.delegate.apply(castEval.value());
    }
}

