/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.groupby.epinephelinae.column.DictionaryBuildingGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.FixedWidthGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.KeyMappingMultiValueGroupByColumnSelectorStrategy;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class GroupByColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<GroupByColumnSelectorStrategy> {
    @Override
    public GroupByColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector, String dimension) {
        if (capabilities == null || capabilities.getType() == null) {
            throw DruidException.defensive("Unable to deduce type for the grouping dimension", new Object[0]);
        }
        try {
            if (!capabilities.toColumnType().getNullableStrategy().groupable()) {
                throw InvalidInput.exception("Unable to group on the column[%s] with type[%s]", dimension, capabilities.toColumnType());
            }
        }
        catch (Exception e) {
            throw InvalidInput.exception(e, "Unable to group on the column[%s]", dimension);
        }
        switch ((ValueType)capabilities.getType()) {
            case STRING: {
                return KeyMappingMultiValueGroupByColumnSelectorStrategy.create(capabilities, (DimensionSelector)selector);
            }
            case LONG: {
                return new FixedWidthGroupByColumnSelectorStrategy<Long>(9, ColumnType.LONG, BaseLongColumnValueSelector::getLong, BaseNullableColumnValueSelector::isNull);
            }
            case FLOAT: {
                return new FixedWidthGroupByColumnSelectorStrategy<Float>(5, ColumnType.FLOAT, BaseFloatColumnValueSelector::getFloat, BaseNullableColumnValueSelector::isNull);
            }
            case DOUBLE: {
                return new FixedWidthGroupByColumnSelectorStrategy<Double>(9, ColumnType.DOUBLE, BaseDoubleColumnValueSelector::getDouble, BaseNullableColumnValueSelector::isNull);
            }
            case ARRAY: {
                switch ((ValueType)capabilities.getElementType().getType()) {
                    case LONG: 
                    case STRING: 
                    case DOUBLE: {
                        return DictionaryBuildingGroupByColumnSelectorStrategy.forType(capabilities.toColumnType());
                    }
                }
                throw new IAE("Cannot create query type helper from invalid type [%s]", capabilities.asTypeString());
            }
            case COMPLEX: {
                return DictionaryBuildingGroupByColumnSelectorStrategy.forType(capabilities.toColumnType());
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", capabilities.asTypeString());
    }

    @Override
    public boolean supportsComplexTypes() {
        return true;
    }
}

