/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.extraction.MapLookupExtractor;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="map", value=MapLookupExtractor.class)})
public abstract class LookupExtractor {
    @Nullable
    public abstract String apply(@Nullable String var1);

    public Map<String, String> applyAll(Iterable<String> keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            map.put(key, this.apply(key));
        }
        return map;
    }

    protected abstract List<String> unapply(@Nullable String var1);

    @Nullable
    public Iterator<String> unapplyAll(Set<String> values) {
        return Iterators.concat((Iterator)Iterators.transform(values.iterator(), value -> this.unapply((String)value).iterator()));
    }

    public abstract boolean supportsAsMap();

    public abstract Map<String, String> asMap();

    public abstract byte[] getCacheKey();

    public boolean isOneToOne() {
        return false;
    }

    public long estimateHeapFootprint() {
        return 0L;
    }
}

