/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.NotYetImplemented;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnValueSwapper;
import org.apache.druid.query.rowsandcols.column.VectorCopier;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ColumnType;

public class LongArrayColumn
implements Column {
    private final long[] vals;

    public LongArrayColumn(long[] vals) {
        this.vals = vals;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        return new MyColumnAccessor();
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        if (VectorCopier.class.equals(clazz)) {
            return (T)((VectorCopier)(into, intoStart) -> {
                if (Integer.MAX_VALUE - this.vals.length < intoStart) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.CAPACITY_EXCEEDED).build("too many rows!!! intoStart[%,d], vals.length[%,d] combine to exceed max_int", intoStart, this.vals.length);
                }
                for (int i = 0; i < this.vals.length; ++i) {
                    into[intoStart + i] = this.vals[i];
                }
            });
        }
        if (ColumnValueSwapper.class.equals(clazz)) {
            return (T)((ColumnValueSwapper)(lhs, rhs) -> {
                long tmp = this.vals[lhs];
                this.vals[lhs] = this.vals[rhs];
                this.vals[rhs] = tmp;
            });
        }
        return null;
    }

    private class MyColumnAccessor
    implements BinarySearchableAccessor {
        private MyColumnAccessor() {
        }

        @Override
        public ColumnType getType() {
            return ColumnType.LONG;
        }

        @Override
        public int numRows() {
            return LongArrayColumn.this.vals.length;
        }

        @Override
        public boolean isNull(int rowNum) {
            return false;
        }

        @Override
        public Object getObject(int rowNum) {
            return LongArrayColumn.this.vals[rowNum];
        }

        @Override
        public double getDouble(int rowNum) {
            return LongArrayColumn.this.vals[rowNum];
        }

        @Override
        public float getFloat(int rowNum) {
            return LongArrayColumn.this.vals[rowNum];
        }

        @Override
        public long getLong(int rowNum) {
            return LongArrayColumn.this.vals[rowNum];
        }

        @Override
        public int getInt(int rowNum) {
            return (int)LongArrayColumn.this.vals[rowNum];
        }

        @Override
        public int compareRows(int lhsRowNum, int rhsRowNum) {
            return Long.compare(LongArrayColumn.this.vals[lhsRowNum], LongArrayColumn.this.vals[rhsRowNum]);
        }

        @Override
        public FindResult findNull(int startIndex, int endIndex) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findDouble(int startIndex, int endIndex, double val) {
            return this.findLong(startIndex, endIndex, (long)val);
        }

        @Override
        public FindResult findFloat(int startIndex, int endIndex, float val) {
            return this.findLong(startIndex, endIndex, (long)val);
        }

        @Override
        public FindResult findLong(int startIndex, int endIndex, long val) {
            if (LongArrayColumn.this.vals[startIndex] == val) {
                int end;
                for (end = startIndex + 1; end < endIndex && LongArrayColumn.this.vals[end] == val; ++end) {
                }
                return FindResult.found(startIndex, end);
            }
            int i = Arrays.binarySearch(LongArrayColumn.this.vals, startIndex, endIndex, val);
            if (i > 0) {
                int foundStart = i;
                int foundEnd = i + 1;
                while (foundStart - 1 >= startIndex && LongArrayColumn.this.vals[foundStart - 1] == val) {
                    --foundStart;
                }
                while (foundEnd < endIndex && LongArrayColumn.this.vals[foundEnd] == val) {
                    ++foundEnd;
                }
                return FindResult.found(foundStart, foundEnd);
            }
            return FindResult.notFound(-(i + 1));
        }

        public FindResult findInt(int startIndex, int endIndex, int val) {
            return this.findLong(startIndex, endIndex, val);
        }

        @Override
        public FindResult findString(int startIndex, int endIndex, String val) {
            throw NotYetImplemented.ex(null, "findString is not currently supported for LongArrayColumns", new Object[0]);
        }

        @Override
        public FindResult findComplex(int startIndex, int endIndex, Object val) {
            throw NotYetImplemented.ex(null, "findComplex is not currently supported for LongArrayColumns", new Object[0]);
        }
    }
}

