/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.SortedMatrixMaker;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ValueType;

public class DefaultSortedMatrixMaker
implements SortedMatrixMaker {
    private final RowsAndColumns rac;

    public DefaultSortedMatrixMaker(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public SortedMatrixMaker.SortedMatrix make(List<String> columns) {
        final ArrayList<BinarySearchableAccessor> soughtColumns = new ArrayList<BinarySearchableAccessor>(columns.size());
        for (String column : columns) {
            Column racColumn = this.rac.findColumn(column);
            if (racColumn == null) {
                soughtColumns.add(null);
                continue;
            }
            soughtColumns.add(BinarySearchableAccessor.fromColumn(racColumn));
        }
        return new SortedMatrixMaker.SortedMatrix(){

            @Override
            public int numRows() {
                return DefaultSortedMatrixMaker.this.rac.numRows();
            }

            @Override
            public SortedMatrixMaker.SortedMatrix.MatrixRow getRow(final int rowId) {
                return new SortedMatrixMaker.SortedMatrix.MatrixRow(){

                    @Override
                    public int length() {
                        return soughtColumns.size();
                    }

                    @Override
                    public boolean isNull(int columnId) {
                        BinarySearchableAccessor column = (BinarySearchableAccessor)soughtColumns.get(columnId);
                        if (column == null) {
                            return true;
                        }
                        return column.isNull(rowId);
                    }

                    @Override
                    public Object getObject(int columnId) {
                        BinarySearchableAccessor column = (BinarySearchableAccessor)soughtColumns.get(columnId);
                        if (column == null) {
                            return null;
                        }
                        return column.getObject(rowId);
                    }

                    @Override
                    public double getDouble(int columnId) {
                        BinarySearchableAccessor column = (BinarySearchableAccessor)soughtColumns.get(columnId);
                        if (column == null) {
                            return 0.0;
                        }
                        return column.getDouble(rowId);
                    }

                    @Override
                    public float getFloat(int columnId) {
                        BinarySearchableAccessor column = (BinarySearchableAccessor)soughtColumns.get(columnId);
                        if (column == null) {
                            return 0.0f;
                        }
                        return column.getFloat(rowId);
                    }

                    @Override
                    public long getLong(int columnId) {
                        BinarySearchableAccessor column = (BinarySearchableAccessor)soughtColumns.get(columnId);
                        if (column == null) {
                            return 0L;
                        }
                        return column.getLong(rowId);
                    }
                };
            }

            @Override
            public FindResult findRow(int startRowIndex, SortedMatrixMaker.SortedMatrix.MatrixRow row) {
                int start = startRowIndex;
                int end = this.numRows();
                for (int i = 0; i < row.length(); ++i) {
                    FindResult result;
                    BinarySearchableAccessor searcher = (BinarySearchableAccessor)soughtColumns.get(i);
                    if (searcher == null) {
                        if (row.isNull(i)) continue;
                        return FindResult.notFound(end);
                    }
                    if (row.isNull(i)) {
                        result = searcher.findNull(start, end);
                    } else {
                        switch ((ValueType)searcher.getType().getType()) {
                            case STRING: {
                                result = searcher.findString(start, end, (String)row.getObject(i));
                                break;
                            }
                            case LONG: {
                                if (row.isNull(i)) {
                                    result = searcher.findNull(start, end);
                                    break;
                                }
                                result = searcher.findLong(start, end, row.getLong(i));
                                break;
                            }
                            case DOUBLE: {
                                result = searcher.findDouble(start, end, row.getDouble(i));
                                break;
                            }
                            case FLOAT: {
                                result = searcher.findFloat(start, end, row.getFloat(i));
                                break;
                            }
                            case ARRAY: 
                            case COMPLEX: {
                                result = searcher.findComplex(start, end, row.getObject(i));
                                break;
                            }
                            default: {
                                throw new RE("Unknown type[%s]", searcher.getType());
                            }
                        }
                    }
                    if (result.wasFound()) {
                        start = result.getStartRow();
                        end = result.getEndRow();
                        continue;
                    }
                    return FindResult.notFound(result.getNext());
                }
                return FindResult.found(start, end);
            }
        };
    }
}

