/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.topn.DimValHolder;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;

public class TopNNumericResultBuilder
implements TopNResultBuilder {
    private final DateTime timestamp;
    private final DimensionSpec dimSpec;
    private final String metricName;
    private final List<PostAggregator> postAggs;
    private final PriorityQueue<DimValHolder> pQueue;
    private final String[] aggFactoryNames;
    private final int threshold;
    private final Comparator metricComparator;
    private static final int LOOP_UNROLL_COUNT = 8;

    public TopNNumericResultBuilder(DateTime timestamp, DimensionSpec dimSpec, String metricName, int threshold, Comparator comparator, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        this.timestamp = timestamp;
        this.dimSpec = dimSpec;
        this.metricName = metricName;
        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(aggFactories);
        this.postAggs = AggregatorUtil.pruneDependentPostAgg(postAggs, this.metricName);
        this.threshold = threshold;
        this.metricComparator = comparator;
        Comparator dimValHolderComparator = (d1, d2) -> {
            int retVal = this.metricComparator.compare(d1.getTopNMetricVal(), d2.getTopNMetricVal());
            if (retVal == 0) {
                retVal = d1.getDimType().getNullableStrategy().compare(d1.getDimValue(), d2.getDimValue());
            }
            return retVal;
        };
        this.pQueue = new PriorityQueue(this.threshold + 1, dimValHolderComparator);
    }

    @Override
    public TopNNumericResultBuilder addEntry(Object dimValueObj, Object dimValIndex, Object[] metricVals) {
        Preconditions.checkArgument((metricVals.length == this.aggFactoryNames.length ? 1 : 0) != 0, (Object)"metricVals must be the same length as aggFactories");
        HashMap metricValues = Maps.newHashMapWithExpectedSize((int)(metricVals.length + this.postAggs.size() + 1));
        metricValues.put(this.dimSpec.getOutputName(), dimValueObj);
        int extra = metricVals.length % 8;
        switch (extra) {
            case 7: {
                metricValues.put(this.aggFactoryNames[6], metricVals[6]);
            }
            case 6: {
                metricValues.put(this.aggFactoryNames[5], metricVals[5]);
            }
            case 5: {
                metricValues.put(this.aggFactoryNames[4], metricVals[4]);
            }
            case 4: {
                metricValues.put(this.aggFactoryNames[3], metricVals[3]);
            }
            case 3: {
                metricValues.put(this.aggFactoryNames[2], metricVals[2]);
            }
            case 2: {
                metricValues.put(this.aggFactoryNames[1], metricVals[1]);
            }
            case 1: {
                metricValues.put(this.aggFactoryNames[0], metricVals[0]);
            }
        }
        for (int i = extra; i < metricVals.length; i += 8) {
            metricValues.put(this.aggFactoryNames[i + 0], metricVals[i + 0]);
            metricValues.put(this.aggFactoryNames[i + 1], metricVals[i + 1]);
            metricValues.put(this.aggFactoryNames[i + 2], metricVals[i + 2]);
            metricValues.put(this.aggFactoryNames[i + 3], metricVals[i + 3]);
            metricValues.put(this.aggFactoryNames[i + 4], metricVals[i + 4]);
            metricValues.put(this.aggFactoryNames[i + 5], metricVals[i + 5]);
            metricValues.put(this.aggFactoryNames[i + 6], metricVals[i + 6]);
            metricValues.put(this.aggFactoryNames[i + 7], metricVals[i + 7]);
        }
        for (PostAggregator postAgg : this.postAggs) {
            metricValues.put(postAgg.getName(), postAgg.compute(metricValues));
        }
        Object topNMetricVal = metricValues.get(this.metricName);
        if (this.shouldAdd(topNMetricVal)) {
            DimValHolder dimValHolder = new DimValHolder.Builder().withTopNMetricVal(topNMetricVal).withDimValue(dimValueObj, this.dimSpec.getOutputType()).withDimValIndex(dimValIndex).withMetricValues(metricValues).build();
            this.pQueue.add(dimValHolder);
        }
        if (this.pQueue.size() > this.threshold) {
            this.pQueue.poll();
        }
        return this;
    }

    private boolean shouldAdd(Object topNMetricVal) {
        boolean belowThreshold = this.pQueue.size() < this.threshold;
        boolean belowMax = belowThreshold || this.metricComparator.compare(this.pQueue.peek().getTopNMetricVal(), topNMetricVal) < 0;
        return belowMax;
    }

    @Override
    public TopNResultBuilder addEntry(DimensionAndMetricValueExtractor dimensionAndMetricValueExtractor) {
        Object dimValue = dimensionAndMetricValueExtractor.getDimensionValue(this.metricName);
        if (this.shouldAdd(dimValue)) {
            DimValHolder valHolder = new DimValHolder.Builder().withTopNMetricVal(dimValue).withDimValue((Comparable)dimensionAndMetricValueExtractor.getDimensionValue(this.dimSpec.getOutputName()), this.dimSpec.getOutputType()).withMetricValues(dimensionAndMetricValueExtractor.getBaseObject()).build();
            this.pQueue.add(valHolder);
        }
        if (this.pQueue.size() > this.threshold) {
            this.pQueue.poll();
        }
        return this;
    }

    @Override
    public Iterator<DimValHolder> getTopNIterator() {
        return this.pQueue.iterator();
    }

    @Override
    public Result<TopNResultValue> build() {
        DimValHolder[] holderValueArray = this.pQueue.toArray(new DimValHolder[0]);
        Arrays.sort(holderValueArray, (d1, d2) -> {
            int retVal = this.metricComparator.compare(d2.getTopNMetricVal(), d1.getTopNMetricVal());
            if (retVal == 0) {
                retVal = d1.getDimType().getNullableStrategy().compare(d1.getDimValue(), d2.getDimValue());
            }
            return retVal;
        });
        List<DimValHolder> holderValues = Arrays.asList(holderValueArray);
        List values = Lists.transform(holderValues, DimValHolder::getMetricValues);
        return new Result<TopNResultValue>(this.timestamp, TopNResultValue.create(values));
    }
}

