/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.AndFilter;

public class FilteredCursorFactory
implements CursorFactory {
    private final CursorFactory delegate;
    @Nullable
    private final DimFilter filter;

    public FilteredCursorFactory(CursorFactory delegate, @Nullable DimFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        CursorBuildSpec.CursorBuildSpecBuilder buildSpecBuilder = CursorBuildSpec.builder(spec);
        Filter newFilter = spec.getFilter() == null ? (this.filter != null ? this.filter.toFilter() : null) : (this.filter != null ? new AndFilter((List<Filter>)ImmutableList.of((Object)spec.getFilter(), (Object)this.filter.toFilter())) : spec.getFilter());
        buildSpecBuilder.setFilter(newFilter);
        return this.delegate.makeCursorHolder(buildSpecBuilder.build());
    }

    @Override
    public RowSignature getRowSignature() {
        return this.delegate.getRowSignature();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.delegate.getColumnCapabilities(column);
    }
}

