/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.SimpleDictionaryMergingIterator;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnSerializerV4;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnMergerV4
implements DimensionMergerV9 {
    private static final Logger log = new Logger(NestedDataColumnMergerV4.class);
    public static final Comparator<PeekingIterator<String>> STRING_MERGING_COMPARATOR = SimpleDictionaryMergingIterator.makePeekingComparator();
    public static final Comparator<PeekingIterator<Long>> LONG_MERGING_COMPARATOR = SimpleDictionaryMergingIterator.makePeekingComparator();
    public static final Comparator<PeekingIterator<Double>> DOUBLE_MERGING_COMPARATOR = SimpleDictionaryMergingIterator.makePeekingComparator();
    private final String name;
    private final IndexSpec indexSpec;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final Closer closer;
    private ColumnDescriptor.Builder descriptorBuilder;
    private NestedDataColumnSerializerV4 serializer;

    public NestedDataColumnMergerV4(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.indexSpec = indexSpec;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.closer = closer;
    }

    @Override
    public void writeMergedValueDictionary(List<IndexableAdapter> adapters) throws IOException {
        try {
            int doubleCardinality;
            int longCardinality;
            int stringCardinality;
            long dimStartTime = System.currentTimeMillis();
            int numMergeIndex = 0;
            SortedValueDictionary sortedLookup = null;
            Indexed[] sortedLookups = new Indexed[adapters.size()];
            Indexed[] sortedLongLookups = new Indexed[adapters.size()];
            Indexed[] sortedDoubleLookups = new Indexed[adapters.size()];
            TreeMap<String, FieldTypeInfo.MutableTypeSet> mergedFields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
            for (int i = 0; i < adapters.size(); ++i) {
                boolean allNulls;
                IndexableAdapter adapter = adapters.get(i);
                IndexableAdapter.NestedColumnMergable mergable = this.closer.register(adapter.getNestedColumnMergeables(this.name));
                if (mergable == null) continue;
                SortedValueDictionary dimValues = mergable.getValueDictionary();
                boolean bl = allNulls = dimValues == null || dimValues.allNull();
                if (allNulls) continue;
                sortedLookup = dimValues;
                mergable.mergeFieldsInto(mergedFields);
                sortedLookups[i] = dimValues.getSortedStrings();
                sortedLongLookups[i] = dimValues.getSortedLongs();
                sortedDoubleLookups[i] = dimValues.getSortedDoubles();
                ++numMergeIndex;
            }
            this.descriptorBuilder = new ColumnDescriptor.Builder();
            this.serializer = new NestedDataColumnSerializerV4(this.name, this.indexSpec, this.segmentWriteOutMedium, this.closer);
            ComplexColumnPartSerde partSerde = ComplexColumnPartSerde.serializerBuilder().withTypeName("json").withDelegate(this.serializer).build();
            this.descriptorBuilder.setValueType(ValueType.COMPLEX).setHasMultipleValues(false).addSerde(partSerde);
            this.serializer.open();
            this.serializer.serializeFields(mergedFields);
            if (numMergeIndex == 1) {
                this.serializer.serializeDictionaries(sortedLookup.getSortedStrings(), sortedLookup.getSortedLongs(), sortedLookup.getSortedDoubles());
                stringCardinality = sortedLookup.getStringCardinality();
                longCardinality = sortedLookup.getLongCardinality();
                doubleCardinality = sortedLookup.getDoubleCardinality();
            } else {
                SimpleDictionaryMergingIterator stringIterator = new SimpleDictionaryMergingIterator(sortedLookups, STRING_MERGING_COMPARATOR);
                SimpleDictionaryMergingIterator longIterator = new SimpleDictionaryMergingIterator(sortedLongLookups, LONG_MERGING_COMPARATOR);
                SimpleDictionaryMergingIterator doubleIterator = new SimpleDictionaryMergingIterator(sortedDoubleLookups, DOUBLE_MERGING_COMPARATOR);
                this.serializer.serializeDictionaries(() -> stringIterator, () -> longIterator, () -> doubleIterator);
                stringCardinality = stringIterator.getCardinality();
                longCardinality = longIterator.getCardinality();
                doubleCardinality = doubleIterator.getCardinality();
            }
            log.debug("Completed dim[%s] conversions with string cardinality[%,d], long cardinality[%,d], double cardinality[%,d] in %,d millis.", this.name, stringCardinality, longCardinality, doubleCardinality, System.currentTimeMillis() - dimStartTime);
        }
        catch (IOException ioe) {
            log.error(ioe, "Failed to merge dictionary for column [%s]", this.name);
            throw ioe;
        }
    }

    @Override
    public ColumnValueSelector convertSortedSegmentRowValuesToMergedRowValues(int segmentIndex, ColumnValueSelector source) {
        return source;
    }

    @Override
    public void processMergedRow(ColumnValueSelector selector) throws IOException {
        this.serializer.serialize(selector);
    }

    @Override
    public void writeIndexes(@Nullable List<IntBuffer> segmentRowNumConversions) {
    }

    @Override
    public boolean hasOnlyNulls() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() {
        return this.descriptorBuilder.build();
    }
}

