/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.UnknownTypeComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;

class SimpleColumnHolder
implements ColumnHolder {
    private final ColumnCapabilities capabilities;
    private final ColumnFormat columnFormat;
    @Nullable
    private final Supplier<? extends BaseColumn> columnSupplier;
    @Nullable
    private final ColumnIndexSupplier indexSupplier;
    private static final InvalidComplexColumnTypeValueSelector INVALID_COMPLEX_COLUMN_TYPE_VALUE_SELECTOR = new InvalidComplexColumnTypeValueSelector();

    SimpleColumnHolder(ColumnCapabilities capabilities, @Nullable ColumnFormat columnFormat, @Nullable Supplier<? extends BaseColumn> columnSupplier, @Nullable ColumnIndexSupplier indexSupplier) {
        this.capabilities = capabilities;
        this.columnSupplier = columnSupplier;
        this.indexSupplier = indexSupplier;
        ColumnFormat columnFormat2 = this.columnFormat = columnFormat == null ? new CapabilitiesBasedFormat(capabilities) : columnFormat;
        if (columnSupplier == null) {
            Preconditions.checkArgument((boolean)capabilities.is(ValueType.COMPLEX), (Object)"Only complex column types can have nullable column suppliers");
        }
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public ColumnFormat getColumnFormat() {
        return this.columnFormat;
    }

    @Override
    public int getLength() {
        try (NumericColumn column = (NumericColumn)this.columnSupplier.get();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public BaseColumn getColumn() {
        return this.columnSupplier == null ? UnknownTypeComplexColumn.instance() : (BaseColumn)this.columnSupplier.get();
    }

    @Override
    public Supplier<? extends BaseColumn> getColumnSupplier() {
        return this.columnSupplier;
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier() {
        return this.indexSupplier;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
        if (this.columnSupplier == null) {
            return INVALID_COMPLEX_COLUMN_TYPE_VALUE_SELECTOR;
        }
        return ValueTypes.makeNewSettableColumnValueSelector((ValueType)this.getCapabilities().getType());
    }

    private static class InvalidComplexColumnTypeValueSelector
    extends SettableObjectColumnValueSelector {
        private InvalidComplexColumnTypeValueSelector() {
        }

        @Override
        public void setValueFrom(ColumnValueSelector selector) {
        }

        @Override
        @Nullable
        public Object getObject() {
            return UnknownTypeComplexColumn.instance().getRowValue(0);
        }
    }
}

