/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.CompressedPools;
import org.apache.druid.segment.data.CompressionStrategy;

public final class CompressedBlockReader
implements Closeable {
    private static final ByteBuffer NULL_VALUE = ByteBuffer.wrap(new byte[0]);
    public static final byte VERSION = 1;
    private final CompressionStrategy.Decompressor decompressor;
    private final boolean copyValuesOnRead;
    private final int numBlocks;
    private final int div;
    private final int rem;
    private final IntBuffer endOffsetsBuffer;
    private final ByteBuffer compressedDataBuffer;
    private final ResourceHolder<ByteBuffer> decompressedDataBufferHolder;
    private final ByteBuffer decompressedDataBuffer;
    private final ByteOrder byteOrder;
    private final Closer closer;
    private int currentBlockNumber = -1;

    public static Supplier<CompressedBlockReader> fromByteBuffer(ByteBuffer buffer, ByteOrder compressionOrder, ByteOrder valueOrder, boolean copyValuesOnRead) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1) {
            CompressionStrategy compression = CompressionStrategy.forId(buffer.get());
            int blockSize = buffer.getInt();
            assert (65536 == blockSize);
            Preconditions.checkState((blockSize <= 65536 ? 1 : 0) != 0, (Object)"Maximum block size must be less than 65536");
            int numBlocks = buffer.getInt();
            int offsetsSize = numBlocks * 4;
            ByteBuffer offsets = buffer.asReadOnlyBuffer().order(compressionOrder);
            offsets.limit(offsets.position() + offsetsSize);
            IntBuffer offsetView = offsets.slice().order(compressionOrder).asIntBuffer();
            int compressedSize = offsetView.get(numBlocks - 1);
            buffer.position(buffer.position() + offsetsSize);
            ByteBuffer compressedData = buffer.asReadOnlyBuffer().order(compressionOrder);
            compressedData.limit(compressedData.position() + compressedSize);
            buffer.position(buffer.position() + compressedSize);
            ByteBuffer compressedDataView = compressedData.slice().order(compressionOrder);
            return () -> new CompressedBlockReader(compression, numBlocks, blockSize, copyValuesOnRead, offsetView.asReadOnlyBuffer(), compressedDataView.asReadOnlyBuffer().order(compressionOrder), compressionOrder, valueOrder);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    public CompressedBlockReader(CompressionStrategy compressionStrategy, int numBlocks, int blockSize, boolean copyValuesOnRead, IntBuffer endOffsetsBuffer, ByteBuffer compressedDataBuffer, ByteOrder compressionByteOrder, ByteOrder valueByteOrder) {
        this.decompressor = compressionStrategy.getDecompressor();
        this.copyValuesOnRead = copyValuesOnRead;
        this.numBlocks = numBlocks;
        this.div = Integer.numberOfTrailingZeros(blockSize);
        this.rem = blockSize - 1;
        this.endOffsetsBuffer = endOffsetsBuffer;
        this.compressedDataBuffer = compressedDataBuffer;
        this.closer = Closer.create();
        this.decompressedDataBufferHolder = CompressedPools.getByteBuf(compressionByteOrder);
        this.closer.register(this.decompressedDataBufferHolder);
        this.decompressedDataBuffer = this.decompressedDataBufferHolder.get();
        this.decompressedDataBuffer.clear();
        this.byteOrder = valueByteOrder;
    }

    public long getSize() {
        return this.endOffsetsBuffer.get(this.numBlocks - 1);
    }

    public int getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    public ByteBuffer getDecompressedDataBuffer() {
        return this.decompressedDataBuffer;
    }

    public ByteBuffer getRange(long startOffset, int size) {
        int readSizeBytes;
        if (size == 0) {
            return NULL_VALUE;
        }
        int startBlockOffset = this.loadBlock(startOffset);
        int startBlockNumber = this.currentBlockNumber;
        this.decompressedDataBuffer.position(startBlockOffset);
        if (size < this.decompressedDataBuffer.remaining()) {
            if (this.copyValuesOnRead) {
                byte[] bytes = new byte[size];
                this.decompressedDataBuffer.get(bytes, 0, size);
                return ByteBuffer.wrap(bytes).order(this.byteOrder);
            }
            ByteBuffer dupe = this.decompressedDataBuffer.duplicate().order(this.byteOrder);
            dupe.position(startBlockOffset).limit(startBlockOffset + size);
            return dupe;
        }
        byte[] bytes = new byte[size];
        int bytesRead = 0;
        int block = startBlockNumber;
        int blockOffset = startBlockOffset;
        do {
            this.seekBlock(block);
            this.decompressedDataBuffer.position(blockOffset);
            readSizeBytes = Math.min(size - bytesRead, this.decompressedDataBuffer.remaining());
            this.decompressedDataBuffer.get(bytes, bytesRead, readSizeBytes);
            ++block;
            blockOffset = 0;
        } while ((bytesRead += readSizeBytes) < size);
        return ByteBuffer.wrap(bytes).order(this.byteOrder);
    }

    public int loadBlock(long startOffset) {
        int startBlockNumber = (int)(startOffset >> this.div);
        int startBlockOffset = (int)(startOffset & (long)this.rem);
        if (startBlockNumber != this.currentBlockNumber) {
            this.seekBlock(startBlockNumber);
        }
        return startBlockOffset;
    }

    public void seekBlock(int block) {
        int blockEndOffset;
        int blockStartOffset;
        if (block == this.currentBlockNumber) {
            return;
        }
        if (block == 0) {
            blockStartOffset = 0;
            blockEndOffset = this.endOffsetsBuffer.get(0);
        } else {
            blockStartOffset = this.endOffsetsBuffer.get(block - 1);
            blockEndOffset = this.endOffsetsBuffer.get(block);
        }
        this.decompressedDataBuffer.clear();
        this.compressedDataBuffer.limit(blockEndOffset);
        this.compressedDataBuffer.position(blockStartOffset);
        this.decompressor.decompress(this.compressedDataBuffer, blockEndOffset - blockStartOffset, this.decompressedDataBuffer);
        this.decompressedDataBuffer.limit(this.decompressedDataBuffer.capacity());
        this.currentBlockNumber = block;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

