/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;

public interface Indexed<T>
extends Iterable<T>,
HotLoopCallee {
    public static <T> Indexed<T> empty() {
        return new Indexed<T>(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            @Nullable
            public T get(int index) {
                Indexed.checkIndex(index, 0);
                return null;
            }

            @Override
            public int indexOf(@Nullable T value) {
                return -1;
            }

            @Override
            public Iterator<T> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
    }

    public int size();

    @Nullable
    public T get(int var1);

    public int indexOf(@Nullable T var1);

    default public boolean isSorted() {
        return false;
    }

    public static void checkIndex(int index, int size) {
        if (index < 0) {
            throw new IAE("Index[%s] < 0", index);
        }
        if (index >= size) {
            throw new IAE("Index[%d] >= size[%d]", index, size);
        }
    }
}

