/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterBundle;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class AndFilter
implements BooleanFilter {
    public static final Joiner AND_JOINER = Joiner.on((String)" && ");
    private final LinkedHashSet<Filter> filters;

    public AndFilter(LinkedHashSet<Filter> filters) {
        Preconditions.checkArgument((filters.size() > 0 ? 1 : 0) != 0, (Object)"Can't construct empty AndFilter");
        this.filters = filters;
    }

    @VisibleForTesting
    public AndFilter(List<Filter> filters) {
        this(new LinkedHashSet<Filter>(filters));
    }

    public static ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                for (ValueMatcher matcher : baseMatchers) {
                    if (matcher.matches(includeUnknown)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }

    public static VectorValueMatcher makeVectorMatcher(final VectorValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new BaseVectorValueMatcher(baseMatchers[0]){

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                ReadableVectorMatch match = mask;
                for (VectorValueMatcher matcher : baseMatchers) {
                    if (match.isAllFalse()) break;
                    match = matcher.match(match, includeUnknown);
                }
                assert (match.isValid(mask));
                return match;
            }
        };
    }

    @Override
    public <T> FilterBundle makeFilterBundle(FilterBundle.Builder filterBundleBuilder, BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
        ArrayList<FilterBundle.IndexBundleInfo> indexBundleInfos = new ArrayList<FilterBundle.IndexBundleInfo>();
        final ArrayList<FilterBundle.MatcherBundle> matcherBundles = new ArrayList<FilterBundle.MatcherBundle>();
        final ArrayList<FilterBundle.MatcherBundleInfo> matcherBundleInfos = new ArrayList<FilterBundle.MatcherBundleInfo>();
        int indexIntersectionSize = totalRowCount;
        ImmutableBitmap index = null;
        ColumnIndexCapabilities merged = new SimpleColumnIndexCapabilities(true, true);
        long bitmapConstructionStartNs = System.nanoTime();
        for (FilterBundle.Builder subFilterBundleBuilder : filterBundleBuilder.getChildBuilders()) {
            FilterBundle subBundle = subFilterBundleBuilder.build(bitmapResultFactory, Math.min(applyRowCount, indexIntersectionSize), totalRowCount, includeUnknown);
            if (subBundle.hasIndex()) {
                if (subBundle.getIndex().getBitmap().isEmpty()) {
                    return FilterBundle.allFalse(System.nanoTime() - bitmapConstructionStartNs, subFilterBundleBuilder.getColumnIndexSelector().getBitmapFactory().makeEmptyImmutableBitmap());
                }
                merged = merged.merge(subBundle.getIndex().getIndexCapabilities());
                indexBundleInfos.add(subBundle.getIndex().getIndexInfo());
                index = index == null ? subBundle.getIndex().getBitmap() : index.intersection(subBundle.getIndex().getBitmap());
                indexIntersectionSize = index.size();
            }
            if (!subBundle.hasMatcher()) continue;
            matcherBundles.add(subBundle.getMatcherBundle());
            matcherBundleInfos.add(subBundle.getMatcherBundle().getMatcherInfo());
        }
        FilterBundle.SimpleIndexBundle indexBundle = index != null ? (indexBundleInfos.size() == 1 ? new FilterBundle.SimpleIndexBundle((FilterBundle.IndexBundleInfo)indexBundleInfos.get(0), index, merged) : new FilterBundle.SimpleIndexBundle(new FilterBundle.IndexBundleInfo(() -> "AND", indexIntersectionSize, System.nanoTime() - bitmapConstructionStartNs, indexBundleInfos), index, merged)) : null;
        FilterBundle.MatcherBundle matcherBundle = !matcherBundles.isEmpty() ? new FilterBundle.MatcherBundle(){

            @Override
            public FilterBundle.MatcherBundleInfo getMatcherInfo() {
                if (matcherBundles.size() == 1) {
                    return (FilterBundle.MatcherBundleInfo)matcherBundleInfos.get(0);
                }
                return new FilterBundle.MatcherBundleInfo(() -> "AND", null, matcherBundleInfos);
            }

            @Override
            public ValueMatcher valueMatcher(ColumnSelectorFactory selectorFactory, Offset baseOffset, boolean descending) {
                ValueMatcher[] matchers = new ValueMatcher[matcherBundles.size()];
                for (int i = 0; i < matcherBundles.size(); ++i) {
                    matchers[i] = ((FilterBundle.MatcherBundle)matcherBundles.get(i)).valueMatcher(selectorFactory, baseOffset, descending);
                }
                return AndFilter.makeMatcher(matchers);
            }

            @Override
            public VectorValueMatcher vectorMatcher(VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset baseOffset) {
                VectorValueMatcher[] vectorMatchers = new VectorValueMatcher[matcherBundles.size()];
                for (int i = 0; i < matcherBundles.size(); ++i) {
                    vectorMatchers[i] = ((FilterBundle.MatcherBundle)matcherBundles.get(i)).vectorMatcher(selectorFactory, baseOffset);
                }
                return AndFilter.makeVectorMatcher(vectorMatchers);
            }

            @Override
            public boolean canVectorize() {
                for (FilterBundle.MatcherBundle bundle : matcherBundles) {
                    if (bundle.canVectorize()) continue;
                    return false;
                }
                return true;
            }
        } : null;
        return new FilterBundle(indexBundle, matcherBundle);
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(final ColumnIndexSelector selector) {
        if (this.filters.size() == 1) {
            return ((Filter)Iterables.getOnlyElement(this.filters)).getBitmapColumnIndex(selector);
        }
        final ArrayList<BitmapColumnIndex> bitmapColumnIndices = new ArrayList<BitmapColumnIndex>(this.filters.size());
        ColumnIndexCapabilities merged = new SimpleColumnIndexCapabilities(true, true);
        for (Filter filter : this.filters) {
            BitmapColumnIndex index = filter.getBitmapColumnIndex(selector);
            if (index == null) {
                return null;
            }
            merged = merged.merge(index.getIndexCapabilities());
            bitmapColumnIndices.add(index);
        }
        final SimpleColumnIndexCapabilities finalMerged = merged;
        return new BitmapColumnIndex(){

            @Override
            public ColumnIndexCapabilities getIndexCapabilities() {
                return finalMerged;
            }

            @Override
            public int estimatedComputeCost() {
                return 0;
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                ArrayList<T> bitmapResults = new ArrayList<T>(bitmapColumnIndices.size());
                for (BitmapColumnIndex index : bitmapColumnIndices) {
                    T bitmapResult = index.computeBitmapResult(bitmapResultFactory, includeUnknown);
                    if (bitmapResultFactory.isEmpty(bitmapResult)) {
                        return bitmapResultFactory.wrapAllFalse(selector.getBitmapFactory().makeEmptyImmutableBitmap());
                    }
                    bitmapResults.add(bitmapResult);
                }
                return bitmapResultFactory.intersection(bitmapResults);
            }

            @Override
            @Nullable
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
                ArrayList<T> bitmapResults = new ArrayList<T>(bitmapColumnIndices.size());
                for (BitmapColumnIndex index : bitmapColumnIndices) {
                    T bitmapResult = index.computeBitmapResult(bitmapResultFactory, applyRowCount, totalRowCount, includeUnknown);
                    if (bitmapResult == null) {
                        return null;
                    }
                    if (bitmapResultFactory.isEmpty(bitmapResult)) {
                        return bitmapResultFactory.wrapAllFalse(selector.getBitmapFactory().makeEmptyImmutableBitmap());
                    }
                    bitmapResults.add(bitmapResult);
                }
                return bitmapResultFactory.intersection(bitmapResults);
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeMatcher(factory);
        }
        return AndFilter.makeMatcher(matchers);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        VectorValueMatcher[] matchers = new VectorValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeVectorMatcher(factory);
        }
        return AndFilter.makeVectorMatcher(matchers);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.filters.stream().allMatch(filter -> filter.canVectorizeMatcher(inspector));
    }

    @Override
    public LinkedHashSet<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        for (Filter filter : this.filters) {
            if (filter.supportsRequiredColumnRewrite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>(this.filters.size());
        for (Filter filter : this.filters) {
            newFilters.add(filter.rewriteRequiredColumns(columnRewrites));
        }
        return new AndFilter(newFilters);
    }

    public String toString() {
        return StringUtils.format("(%s)", AND_JOINER.join(this.filters));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndFilter andFilter = (AndFilter)o;
        return Objects.equals(this.getFilters(), andFilter.getFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getFilters());
    }
}

