/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index.semantic;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapDelegatingIterableIndex;

public interface ValueSetIndexes {
    public static final double SORTED_SCAN_RATIO_THRESHOLD = 0.12;
    public static final int SIZE_WORTH_CHECKING_MIN = 8;

    @Nullable
    public BitmapColumnIndex forSortedValues(@Nonnull List<?> var1, TypeSignature<ValueType> var2);

    public static <T> BitmapColumnIndex buildBitmapColumnIndexFromSortedIteratorScan(BitmapFactory bitmapFactory, final Comparator<T> comparator, final Iterable<T> values, final int size, final Indexed<T> dictionary, Indexed<ImmutableBitmap> bitmaps, Supplier<ImmutableBitmap> unknownsBitmap) {
        return new BaseValueSetIndexesFromIterable(bitmapFactory, bitmaps, unknownsBitmap){

            @Override
            public int estimatedComputeCost() {
                return Integer.max(size, dictionary.size());
            }

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    int next;
                    int idx;
                    final PeekingIterator valuesIterator;
                    final PeekingIterator dictionaryIterator;
                    {
                        this.valuesIterator = Iterators.peekingIterator(values.iterator());
                        this.dictionaryIterator = Iterators.peekingIterator(dictionary.iterator());
                        this.next = -1;
                        this.idx = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next < 0) {
                            this.findNext();
                        }
                        return this.next >= 0;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (this.next < 0) {
                            this.findNext();
                            if (this.next < 0) {
                                throw new NoSuchElementException();
                            }
                        }
                        int swap = this.next;
                        this.next = -1;
                        return this.getBitmap(swap);
                    }

                    private void findNext() {
                        while (this.next < 0 && this.valuesIterator.hasNext() && this.dictionaryIterator.hasNext()) {
                            Object nextDictionaryKey;
                            Object nextValue = this.valuesIterator.peek();
                            int comparison = comparator.compare(nextValue, nextDictionaryKey = this.dictionaryIterator.peek());
                            if (comparison == 0) {
                                this.next = this.idx;
                                this.valuesIterator.next();
                                break;
                            }
                            if (comparison < 0) {
                                this.valuesIterator.next();
                                continue;
                            }
                            this.dictionaryIterator.next();
                            ++this.idx;
                        }
                    }
                };
            }
        };
    }

    public static <T> BitmapColumnIndex buildBitmapColumnIndexFromSortedIteratorBinarySearch(BitmapFactory bitmapFactory, final Iterable<T> values, final int size, final Indexed<T> dictionary, Indexed<ImmutableBitmap> bitmaps, Supplier<ImmutableBitmap> getUnknownsIndex) {
        return new BaseValueSetIndexesFromIterable(bitmapFactory, bitmaps, getUnknownsIndex){

            @Override
            public int estimatedComputeCost() {
                return size;
            }

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    final int dictionarySize;
                    int next;
                    final Iterator iterator;
                    {
                        this.dictionarySize = dictionary.size();
                        this.iterator = values.iterator();
                        this.next = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next < 0) {
                            this.findNext();
                        }
                        return this.next >= 0;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (this.next < 0) {
                            this.findNext();
                            if (this.next < 0) {
                                throw new NoSuchElementException();
                            }
                        }
                        int swap = this.next;
                        this.next = -1;
                        return this.getBitmap(swap);
                    }

                    private void findNext() {
                        while (this.next < 0 && this.iterator.hasNext()) {
                            Object nextValue = this.iterator.next();
                            this.next = dictionary.indexOf(nextValue);
                            if (this.next != -this.dictionarySize - 1) continue;
                            break;
                        }
                    }
                };
            }
        };
    }

    public static <T> BitmapColumnIndex buildBitmapColumnIndexFromIteratorBinarySearch(BitmapFactory bitmapFactory, final Iterable<T> values, final int size, final Indexed<T> dictionary, Indexed<ImmutableBitmap> bitmaps, Supplier<ImmutableBitmap> getUnknownsIndex) {
        return new BaseValueSetIndexesFromIterable(bitmapFactory, bitmaps, getUnknownsIndex){

            @Override
            public int estimatedComputeCost() {
                return size;
            }

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    int next;
                    final Iterator iterator;
                    {
                        this.iterator = values.iterator();
                        this.next = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next < 0) {
                            this.findNext();
                        }
                        return this.next >= 0;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (this.next < 0) {
                            this.findNext();
                            if (this.next < 0) {
                                throw new NoSuchElementException();
                            }
                        }
                        int swap = this.next;
                        this.next = -1;
                        return this.getBitmap(swap);
                    }

                    private void findNext() {
                        while (this.next < 0 && this.iterator.hasNext()) {
                            Object nextValue = this.iterator.next();
                            this.next = dictionary.indexOf(nextValue);
                        }
                    }
                };
            }
        };
    }

    public static abstract class BaseValueSetIndexesFromIterable
    extends SimpleImmutableBitmapDelegatingIterableIndex {
        private final Indexed<ImmutableBitmap> bitmaps;
        private final BitmapFactory bitmapFactory;
        private final Supplier<ImmutableBitmap> unknownsBitmap;

        public BaseValueSetIndexesFromIterable(BitmapFactory bitmapFactory, Indexed<ImmutableBitmap> bitmaps, Supplier<ImmutableBitmap> unknownsBitmap) {
            this.bitmaps = bitmaps;
            this.bitmapFactory = bitmapFactory;
            this.unknownsBitmap = unknownsBitmap;
        }

        @Override
        @Nullable
        protected ImmutableBitmap getUnknownsBitmap() {
            return (ImmutableBitmap)this.unknownsBitmap.get();
        }

        protected ImmutableBitmap getBitmap(int idx) {
            if (idx < 0) {
                return this.bitmapFactory.makeEmptyImmutableBitmap();
            }
            ImmutableBitmap bitmap = this.bitmaps.get(idx);
            return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
        }
    }
}

