/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.MapIndex;
import org.apache.druid.segment.join.table.UniqueLongArrayIndex;

public class RowBasedIndexBuilder {
    private static final long INT_ARRAY_SPACE_SAVINGS_FACTOR = 15L;
    private static final long INT_ARRAY_SMALL_SIZE_OK = 250000L;
    private int currentRow = 0;
    private int nonNullKeys = 0;
    private final ColumnType keyType;
    private final Map<Object, IntSortedSet> index;
    private IntSortedSet nullIndex;
    private long minLongKey = Long.MAX_VALUE;
    private long maxLongKey = Long.MIN_VALUE;

    public RowBasedIndexBuilder(ColumnType keyType) {
        Long2ObjectOpenHashMap theMap;
        this.keyType = keyType;
        if (keyType.is(ValueType.COMPLEX) || keyType.isArray() && !keyType.isPrimitiveArray()) {
            throw InvalidInput.exception("Cannot join when the join condition has column of type [%s]", keyType);
        }
        this.index = keyType.is(ValueType.LONG) ? (theMap = new Long2ObjectOpenHashMap()) : new HashMap<Object, IntSortedSet>();
    }

    public RowBasedIndexBuilder add(@Nullable Object key) {
        if (key == null) {
            if (this.nullIndex == null) {
                this.nullIndex = new IntAVLTreeSet();
            }
            this.nullIndex.add(this.currentRow);
        } else {
            Object castKey = DimensionHandlerUtils.convertObjectToType(key, this.keyType);
            if (castKey != null) {
                this.index.computeIfAbsent(castKey, k -> new IntAVLTreeSet()).add(this.currentRow);
                ++this.nonNullKeys;
                if (this.keyType.is(ValueType.LONG) && (Long)castKey < this.minLongKey) {
                    this.minLongKey = (Long)castKey;
                }
                if (this.keyType.is(ValueType.LONG) && (Long)castKey > this.maxLongKey) {
                    this.maxLongKey = (Long)castKey;
                }
            }
        }
        ++this.currentRow;
        return this;
    }

    public IndexedTable.Index build() {
        boolean nonNullKeysUnique;
        boolean bl = nonNullKeysUnique = this.index.size() == this.nonNullKeys;
        if (this.keyType.is(ValueType.LONG) && nonNullKeysUnique && !this.index.isEmpty() && this.nullIndex == null) {
            long range;
            try {
                range = Math.addExact(Math.subtractExact(this.maxLongKey, this.minLongKey), 1L);
            }
            catch (ArithmeticException e) {
                range = 0L;
            }
            long rangeThreshold = Math.max(250000L, Math.min(Integer.MAX_VALUE, 15L * (long)this.index.size()));
            if (range > 0L && range < rangeThreshold) {
                int[] indexAsArray = new int[Ints.checkedCast((long)range)];
                Arrays.fill(indexAsArray, -1);
                ObjectIterator entries = ((Long2ObjectMap)this.index).long2ObjectEntrySet().iterator();
                while (entries.hasNext()) {
                    Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)entries.next();
                    IntSortedSet rowNums = (IntSortedSet)entry.getValue();
                    if (rowNums.size() != 1) {
                        throw new ISE("Expected single element", new Object[0]);
                    }
                    indexAsArray[Ints.checkedCast((long)(entry.getLongKey() - this.minLongKey))] = rowNums.firstInt();
                    entries.remove();
                }
                assert (this.index.isEmpty());
                return new UniqueLongArrayIndex(indexAsArray, this.minLongKey);
            }
        }
        return new MapIndex(this.keyType, this.index, this.nullIndex, nonNullKeysUnique);
    }
}

