/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.IndexedInts;

public class CombineFirstTwoValuesIndexedInts
implements IndexedInts {
    private static final int ZERO_ID = 0;
    IndexedInts delegate;

    public CombineFirstTwoValuesIndexedInts(IndexedInts delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public int get(int index) {
        int i = this.delegate.get(index);
        if (i == 0) {
            return i;
        }
        return i - 1;
    }

    @Override
    public void get(int[] out, int start, int length) {
        this.delegate.get(out, start, length);
        for (int i = 0; i < length; ++i) {
            if (out[i] == 0) continue;
            int n = i;
            out[n] = out[n] - 1;
        }
    }

    @Override
    public void get(int[] out, int[] indexes, int length) {
        this.delegate.get(out, indexes, length);
        for (int i = 0; i < length; ++i) {
            if (out[i] == 0) continue;
            int n = i;
            out[n] = out[n] - 1;
        }
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        this.delegate.inspectRuntimeShape(inspector);
    }
}

