/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class ComplexMetrics {
    private static final ConcurrentHashMap<String, ComplexMetricSerde> COMPLEX_SERIALIZERS = new ConcurrentHashMap();

    @Nullable
    public static ComplexMetricSerde getSerdeForType(String type) {
        return COMPLEX_SERIALIZERS.get(type);
    }

    public static void registerSerde(String type, ComplexMetricSerde serde) {
        COMPLEX_SERIALIZERS.compute(type, (key, value) -> {
            if (value == null) {
                TypeStrategies.registerComplex(type, serde.getTypeStrategy());
                return serde;
            }
            if (!value.getClass().getName().equals(serde.getClass().getName())) {
                throw new ISE("Incompatible serializer for type[%s] already exists. Expected [%s], found [%s].", key, serde.getClass().getName(), value.getClass().getName());
            }
            return value;
        });
    }

    public static void unregisterSerde(String type) {
        COMPLEX_SERIALIZERS.remove(type);
    }
}

