/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.segment.serde.cell.NumberSerializer;

public class IntSerializer
implements NumberSerializer {
    private final ByteBuffer intValueByteBuffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());

    @Override
    public ByteBuffer serialize(long value) {
        this.intValueByteBuffer.clear();
        this.intValueByteBuffer.putInt(Ints.checkedCast((long)value)).flip();
        return this.intValueByteBuffer;
    }

    @Override
    public int getSerializedSize() {
        return 4;
    }
}

