/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;

public class NumberedOverwritePartialShardSpec
implements PartialShardSpec {
    private final int startRootPartitionId;
    private final int endRootPartitionId;
    private final short minorVersion;

    @JsonCreator
    public NumberedOverwritePartialShardSpec(@JsonProperty(value="startRootPartitionId") int startRootPartitionId, @JsonProperty(value="endRootPartitionId") int endRootPartitionId, @JsonProperty(value="minorVersion") short minorVersion) {
        this.startRootPartitionId = startRootPartitionId;
        this.endRootPartitionId = endRootPartitionId;
        this.minorVersion = minorVersion;
    }

    @VisibleForTesting
    public NumberedOverwritePartialShardSpec(int startRootPartitionId, int endRootPartitionId, int minorVersion) {
        this(startRootPartitionId, endRootPartitionId, (short)minorVersion);
    }

    @JsonProperty
    public int getStartRootPartitionId() {
        return this.startRootPartitionId;
    }

    @JsonProperty
    public int getEndRootPartitionId() {
        return this.endRootPartitionId;
    }

    @JsonProperty
    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public ShardSpec complete(ObjectMapper objectMapper, int partitionId, int numCorePartitions) {
        return new NumberedOverwriteShardSpec(partitionId, this.startRootPartitionId, this.endRootPartitionId, this.minorVersion);
    }

    @Override
    public Class<? extends ShardSpec> getShardSpecClass() {
        return NumberedOverwriteShardSpec.class;
    }

    @Override
    public boolean useNonRootGenerationPartitionSpace() {
        return true;
    }
}

