/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skife.config.DataAmountUnit;

public class DataAmount {
    private final long value;
    private final DataAmountUnit unit;
    private final long numBytes;
    private static final Pattern SPLIT = Pattern.compile("^(\\d+)(\\w+)$");

    public DataAmount(String spec) {
        Matcher m = SPLIT.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid data amount", spec));
        }
        String number = m.group(1);
        String type = m.group(2);
        this.value = Long.parseLong(number);
        this.unit = DataAmountUnit.fromString(type);
        this.numBytes = this.unit.getFactor() * this.value;
    }

    public DataAmount(long value, DataAmountUnit unit) {
        this.value = value;
        this.unit = unit;
        this.numBytes = unit.getFactor() * value;
    }

    public long getValue() {
        return this.value;
    }

    public DataAmountUnit getUnit() {
        return this.unit;
    }

    public long getNumberOfBytes() {
        return this.numBytes;
    }

    public DataAmount convertTo(DataAmountUnit unit) {
        return new DataAmount(this.numBytes / unit.getFactor(), unit);
    }

    public String toString() {
        return this.value + this.unit.getSymbol();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.numBytes ^ this.numBytes >>> 32);
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataAmount other = (DataAmount)obj;
        return this.numBytes == other.numBytes;
    }
}

