/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.guice.maven;

import java.io.File;
import javax.inject.Provider;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBehaviourRepositoryProvider
implements Provider<RemoteRepository> {
    public RemoteRepository get() {
        return this.getRemoteRepository();
    }

    public RemoteRepository getRemoteRepository() {
        String repositoryId = "central";
        String repositoryUrl = "http://repo1.maven.org/maven2";
        String repoUser = null;
        String repoPass = null;
        Settings settings = this.readMavenSettings();
        if (settings != null && settings.getMirrors() != null && settings.getMirrors().size() == 1) {
            Mirror mirror = (Mirror)settings.getMirrors().get(0);
            repositoryUrl = mirror.getUrl();
            repositoryId = mirror.getId();
            if (settings.getServer(repositoryId) != null) {
                repoUser = settings.getServer(repositoryId).getUsername();
                repoPass = settings.getServer(repositoryId).getPassword();
            }
        }
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repositoryId, "default", repositoryUrl);
        if (repoUser != null && repoPass != null) {
            Authentication auth = new AuthenticationBuilder().addUsername(repoUser).addPassword(repoPass).build();
            builder.setAuthentication(auth);
        }
        return builder.build();
    }

    public Settings readMavenSettings() {
        Settings settings;
        File userSettingsFile = new File(System.getProperty("user.home"), ".m2/settings.xml");
        if (!userSettingsFile.exists()) {
            return null;
        }
        DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setSystemProperties(System.getProperties());
        request.setUserSettingsFile(userSettingsFile);
        try {
            settings = settingsBuilder.build((SettingsBuildingRequest)request).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            settings = new Settings();
        }
        return settings;
    }
}

