/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.security.basic.authorization.MetadataStoreRoleProvider;
import org.apache.druid.security.basic.authorization.RoleProvider;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerPermission;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.Resource;

@JsonTypeName(value="basic")
public class BasicRoleBasedAuthorizer
implements Authorizer {
    private final String name;
    private final BasicAuthDBConfig dbConfig;
    private final RoleProvider roleProvider;

    @JsonCreator
    public BasicRoleBasedAuthorizer(@JacksonInject BasicAuthorizerCacheManager cacheManager, @JsonProperty(value="name") String name, @JsonProperty(value="initialAdminUser") String initialAdminUser, @JsonProperty(value="initialAdminRole") String initialAdminRole, @JsonProperty(value="initialAdminGroupMapping") String initialAdminGroupMapping, @JsonProperty(value="enableCacheNotifications") Boolean enableCacheNotifications, @JsonProperty(value="cacheNotificationTimeout") Long cacheNotificationTimeout, @JsonProperty(value="roleProvider") RoleProvider roleProvider) {
        this.name = name;
        this.dbConfig = new BasicAuthDBConfig(null, null, initialAdminUser, initialAdminRole, initialAdminGroupMapping, enableCacheNotifications == null ? true : enableCacheNotifications, cacheNotificationTimeout == null ? 5000L : cacheNotificationTimeout, 0);
        this.roleProvider = roleProvider == null ? new MetadataStoreRoleProvider(cacheManager) : roleProvider;
    }

    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
        if (authenticationResult == null) {
            throw new IAE("authenticationResult is null where it should never be.", new Object[0]);
        }
        HashSet<String> roleNames = new HashSet<String>(this.roleProvider.getRoles(this.name, authenticationResult));
        Map<String, BasicAuthorizerRole> roleMap = this.roleProvider.getRoleMap(this.name);
        if (roleNames.isEmpty()) {
            return new Access(false);
        }
        if (roleMap == null) {
            throw new IAE("Could not load roleMap for authorizer [%s]", new Object[]{this.name});
        }
        for (String roleName : roleNames) {
            BasicAuthorizerRole role = roleMap.get(roleName);
            if (role == null) continue;
            for (BasicAuthorizerPermission permission : role.getPermissions()) {
                if (!this.permissionCheck(resource, action, permission)) continue;
                return new Access(true);
            }
        }
        return new Access(false);
    }

    private boolean permissionCheck(Resource resource, Action action, BasicAuthorizerPermission permission) {
        if (action != permission.getResourceAction().getAction()) {
            return false;
        }
        Resource permissionResource = permission.getResourceAction().getResource();
        if (!Objects.equals(permissionResource.getType(), resource.getType())) {
            return false;
        }
        Pattern resourceNamePattern = permission.getResourceNamePattern();
        Matcher resourceNameMatcher = resourceNamePattern.matcher(resource.getName());
        return resourceNameMatcher.matches();
    }

    public BasicAuthDBConfig getDbConfig() {
        return this.dbConfig;
    }
}

