/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointAddress is a tuple that describes single IP address.")
public class V1EndpointAddress {
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private String ip;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_TARGET_REF = "targetRef";
    @SerializedName(value="targetRef")
    private V1ObjectReference targetRef;

    public V1EndpointAddress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Hostname of this endpoint")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1EndpointAddress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(required=true, value="The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public V1EndpointAddress nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1EndpointAddress targetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointAddress v1EndpointAddress = (V1EndpointAddress)o;
        return Objects.equals(this.hostname, v1EndpointAddress.hostname) && Objects.equals(this.ip, v1EndpointAddress.ip) && Objects.equals(this.nodeName, v1EndpointAddress.nodeName) && Objects.equals(this.targetRef, v1EndpointAddress.targetRef);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointAddress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

