/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==\"\"`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.")
public class V1beta3ResourcePolicyRule {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    private List<String> apiGroups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CLUSTER_SCOPE = "clusterScope";
    @SerializedName(value="clusterScope")
    private Boolean clusterScope;
    public static final String SERIALIZED_NAME_NAMESPACES = "namespaces";
    @SerializedName(value="namespaces")
    private List<String> namespaces = null;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERBS = "verbs";
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();

    public V1beta3ResourcePolicyRule apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1beta3ResourcePolicyRule addApiGroupsItem(String apiGroupsItem) {
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`apiGroups` is a list of matching API groups and may not be empty. \"*\" matches all API groups and, if present, must be the only entry. Required.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1beta3ResourcePolicyRule clusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.")
    public Boolean getClusterScope() {
        return this.clusterScope;
    }

    public void setClusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
    }

    public V1beta3ResourcePolicyRule namespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public V1beta3ResourcePolicyRule addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains \"*\".  Note that \"*\" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.")
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public V1beta3ResourcePolicyRule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1beta3ResourcePolicyRule addResourcesItem(String resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ \"services\", \"nodes/status\" ].  This list may not be empty. \"*\" matches all resources and, if present, must be the only entry. Required.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public V1beta3ResourcePolicyRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1beta3ResourcePolicyRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`verbs` is a list of matching verbs and may not be empty. \"*\" matches all verbs and, if present, must be the only entry. Required.")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta3ResourcePolicyRule v1beta3ResourcePolicyRule = (V1beta3ResourcePolicyRule)o;
        return Objects.equals(this.apiGroups, v1beta3ResourcePolicyRule.apiGroups) && Objects.equals(this.clusterScope, v1beta3ResourcePolicyRule.clusterScope) && Objects.equals(this.namespaces, v1beta3ResourcePolicyRule.namespaces) && Objects.equals(this.resources, v1beta3ResourcePolicyRule.resources) && Objects.equals(this.verbs, v1beta3ResourcePolicyRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.clusterScope, this.namespaces, this.resources, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta3ResourcePolicyRule {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    clusterScope: ").append(this.toIndentedString(this.clusterScope)).append("\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

