/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class CastedLiteralOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    public static SqlSingleOperandTypeChecker LITERAL = new CastedLiteralOperandTypeChecker(false);
    private final boolean allowNull;

    CastedLiteralOperandTypeChecker(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        Util.discard((int)iFormalOperand);
        if (SqlUtil.isNullLiteral((SqlNode)node, (boolean)true)) {
            if (this.allowNull) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustNotBeNull(callBinding.getOperator().getName()));
            }
            return false;
        }
        if (!SqlUtil.isLiteral((SqlNode)node, (boolean)true) && !SqlUtil.isLiteralChain((SqlNode)node)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustBeLiteral(callBinding.getOperator().getName()));
            }
            return false;
        }
        return true;
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<LITERAL>";
    }
}

