/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.util.Set;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.http.SqlQuery;

public class HttpStatement
extends DirectStatement {
    private final HttpServletRequest req;

    public HttpStatement(SqlToolbox lifecycleToolbox, SqlQuery sqlQuery, HttpServletRequest req) {
        super(lifecycleToolbox, SqlQueryPlus.builder(sqlQuery).auth(AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req)).build(), req.getRemoteAddr());
        this.req = req;
    }

    @Override
    protected Function<Set<ResourceAction>, Access> authorizer() {
        return resourceActions -> AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)this.req, (Iterable)resourceActions, (AuthorizerMapper)this.sqlToolbox.plannerFactory.getAuthorizerMapper());
    }
}

