/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.filtration.BottomUpTransform;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.BoundValue;
import org.apache.druid.sql.calcite.filtration.Bounds;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.filtration.RangeRefKey;
import org.apache.druid.sql.calcite.filtration.RangeSets;
import org.apache.druid.sql.calcite.filtration.RangeValue;
import org.apache.druid.sql.calcite.filtration.Ranges;

public class CombineAndSimplifyBounds
extends BottomUpTransform {
    private static final CombineAndSimplifyBounds INSTANCE = new CombineAndSimplifyBounds();

    private CombineAndSimplifyBounds() {
    }

    public static CombineAndSimplifyBounds instance() {
        return INSTANCE;
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof FalseDimFilter) {
            return filter;
        }
        if (filter instanceof AndDimFilter) {
            List<DimFilter> children = this.getAndFilterChildren((AndDimFilter)filter);
            return CombineAndSimplifyBounds.doSimplifyAnd(children);
        }
        if (filter instanceof OrDimFilter) {
            List<DimFilter> children = this.getOrFilterChildren((OrDimFilter)filter);
            return CombineAndSimplifyBounds.doSimplifyOr(children);
        }
        if (filter instanceof NotDimFilter) {
            DimFilter field = ((NotDimFilter)filter).getField();
            return CombineAndSimplifyBounds.negate(field);
        }
        return filter;
    }

    private List<DimFilter> getAndFilterChildren(AndDimFilter filter) {
        ArrayList<DimFilter> children = new ArrayList<DimFilter>();
        for (DimFilter field : filter.getFields()) {
            if (field instanceof AndDimFilter) {
                children.addAll(this.getAndFilterChildren((AndDimFilter)field));
                continue;
            }
            children.add(field);
        }
        return children;
    }

    private List<DimFilter> getOrFilterChildren(OrDimFilter filter) {
        ArrayList<DimFilter> children = new ArrayList<DimFilter>();
        for (DimFilter field : filter.getFields()) {
            if (field instanceof OrDimFilter) {
                children.addAll(this.getOrFilterChildren((OrDimFilter)field));
                continue;
            }
            children.add(field);
        }
        return children;
    }

    private static DimFilter doSimplifyAnd(List<DimFilter> children) {
        return CombineAndSimplifyBounds.doSimplify(children, false);
    }

    private static DimFilter doSimplifyOr(List<DimFilter> children) {
        return CombineAndSimplifyBounds.doSimplify(children, true);
    }

    private static DimFilter doSimplify(List<DimFilter> children, boolean disjunction) {
        List filterList;
        ArrayList<Object> childrenToAdd = new ArrayList<Object>();
        IntOpenHashSet childrenToRemove = new IntOpenHashSet();
        HashMap<BoundRefKey, List> bounds = new HashMap<BoundRefKey, List>();
        HashMap<RangeRefKey, List> ranges = new HashMap<RangeRefKey, List>();
        HashMap<String, ColumnType> leastRestrictiveNumericTypes = new HashMap<String, ColumnType>();
        boolean allFalse = true;
        for (int childIndex = 0; childIndex < children.size(); ++childIndex) {
            DimFilter dimFilter = children.get(childIndex);
            if (dimFilter instanceof BoundDimFilter) {
                BoundDimFilter bound = (BoundDimFilter)dimFilter;
                BoundRefKey boundRefKey = BoundRefKey.from(bound);
                filterList = bounds.computeIfAbsent(boundRefKey, k -> new ArrayList());
                filterList.add(ObjectIntPair.of((Object)bound, (int)childIndex));
                allFalse = false;
                continue;
            }
            if (dimFilter instanceof RangeFilter) {
                RangeFilter range = (RangeFilter)dimFilter;
                RangeRefKey rangeRefKey = RangeRefKey.from(range);
                if (rangeRefKey.getMatchValueType().isNumeric()) {
                    leastRestrictiveNumericTypes.compute(range.getColumn(), (c, existingType) -> ColumnType.leastRestrictiveType((ColumnType)existingType, (ColumnType)range.getMatchValueType()));
                }
                filterList = ranges.computeIfAbsent(rangeRefKey, k -> new ArrayList());
                filterList.add(ObjectIntPair.of((Object)range, (int)childIndex));
                allFalse = false;
                continue;
            }
            allFalse = allFalse && dimFilter instanceof FalseDimFilter;
        }
        if (allFalse) {
            return Filtration.matchNothing();
        }
        for (Map.Entry entry : bounds.entrySet()) {
            RangeSet rangeSet;
            BoundRefKey boundRefKey = (BoundRefKey)entry.getKey();
            List filterList2 = (List)entry.getValue();
            RangeSet rangeSet2 = rangeSet = disjunction ? RangeSets.unionRanges(Bounds.toRanges(Lists.transform((List)filterList2, Pair::left))) : RangeSets.intersectRanges(Bounds.toRanges(Lists.transform((List)filterList2, Pair::left)));
            if (rangeSet.asRanges().size() < filterList2.size()) {
                for (ObjectIntPair boundAndChildIndex : filterList2) {
                    childrenToRemove.add(boundAndChildIndex.rightInt());
                }
                if (rangeSet.asRanges().isEmpty()) {
                    childrenToAdd.add(Filtration.matchNothing());
                }
                for (Range range : rangeSet.asRanges()) {
                    if (!range.hasLowerBound() && !range.hasUpperBound()) {
                        childrenToAdd.add(Filtration.matchEverything());
                        continue;
                    }
                    childrenToAdd.add(Bounds.toFilter(boundRefKey, (Range<BoundValue>)range));
                }
                continue;
            }
            if (!disjunction || !Range.all().equals((Object)rangeSet.span())) continue;
            for (ObjectIntPair boundAndChildIndex : filterList2) {
                childrenToRemove.add(boundAndChildIndex.rightInt());
            }
            Set newRanges = rangeSet.complement().asRanges();
            Iterator<BoundDimFilter> newFilters = new ArrayList();
            for (Range range : newRanges) {
                BoundDimFilter filter = Bounds.toFilter(boundRefKey, (Range<BoundValue>)range);
                newFilters.add(filter);
            }
            childrenToAdd.add(new NotDimFilter(CombineAndSimplifyBounds.disjunction(newFilters)));
        }
        HashMap consolidatedRanges = Maps.newHashMapWithExpectedSize((int)ranges.size());
        for (Map.Entry entry : ranges.entrySet()) {
            ColumnType numericTypeToUse;
            boolean refKeyChanged = false;
            RangeRefKey refKey = (RangeRefKey)entry.getKey();
            if (((RangeRefKey)entry.getKey()).getMatchValueType().isNumeric() && !(numericTypeToUse = (ColumnType)leastRestrictiveNumericTypes.get(refKey.getColumn())).equals((Object)refKey.getMatchValueType())) {
                refKeyChanged = true;
                refKey = new RangeRefKey(refKey.getColumn(), numericTypeToUse);
            }
            List consolidatedFilterList = consolidatedRanges.computeIfAbsent(refKey, k -> new ArrayList());
            if (refKeyChanged) {
                for (ObjectIntPair filterAndChildIndex : (List)entry.getValue()) {
                    RangeFilter rewrite = Ranges.toFilter(refKey, Ranges.toRange((RangeFilter)filterAndChildIndex.left(), refKey.getMatchValueType()));
                    consolidatedFilterList.add(ObjectIntPair.of((Object)rewrite, (int)filterAndChildIndex.rightInt()));
                }
                continue;
            }
            consolidatedFilterList.addAll((Collection)entry.getValue());
        }
        for (Map.Entry entry : consolidatedRanges.entrySet()) {
            RangeSet rangeSet;
            RangeRefKey rangeRefKey = (RangeRefKey)entry.getKey();
            filterList = (List)entry.getValue();
            RangeSet rangeSet3 = rangeSet = disjunction ? RangeSets.unionRanges(Ranges.toRanges(Lists.transform((List)filterList, Pair::left))) : RangeSets.intersectRanges(Ranges.toRanges(Lists.transform((List)filterList, Pair::left)));
            if (rangeSet.asRanges().size() < filterList.size()) {
                for (ObjectIntPair rangeAndChildIndex : filterList) {
                    childrenToRemove.add(rangeAndChildIndex.rightInt());
                }
                if (rangeSet.asRanges().isEmpty()) {
                    childrenToAdd.add(Filtration.matchNothing());
                }
                for (Range range : rangeSet.asRanges()) {
                    if (!range.hasLowerBound() && !range.hasUpperBound()) {
                        childrenToAdd.add(Filtration.matchEverything());
                        continue;
                    }
                    childrenToAdd.add(Ranges.toFilter(rangeRefKey, (Range<RangeValue>)range));
                }
                continue;
            }
            if (!disjunction || !Range.all().equals((Object)rangeSet.span())) continue;
            for (ObjectIntPair boundAndChildIndex : filterList) {
                childrenToRemove.add(boundAndChildIndex.rightInt());
            }
            Set newRanges = rangeSet.complement().asRanges();
            ArrayList<DimFilter> newFilters = new ArrayList<DimFilter>();
            for (Range range : newRanges) {
                RangeFilter filter = Ranges.toFilter(rangeRefKey, (Range<RangeValue>)range);
                newFilters.add((DimFilter)filter);
            }
            childrenToAdd.add(new NotDimFilter(CombineAndSimplifyBounds.disjunction(newFilters)));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(children.size() + childrenToAdd.size() - childrenToRemove.size());
        for (int i = 0; i < children.size(); ++i) {
            if (childrenToRemove.contains(i)) continue;
            arrayList.add(children.get(i));
        }
        arrayList.addAll(childrenToAdd);
        Preconditions.checkState((arrayList.size() > 0 ? 1 : 0) != 0, (Object)"newChildren.size > 0");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DimFilter newChild = (DimFilter)iterator.next();
            if (Filtration.matchNothing().equals(newChild)) {
                if (disjunction) {
                    iterator.remove();
                    continue;
                }
                return Filtration.matchNothing();
            }
            if (!Filtration.matchEverything().equals(newChild)) continue;
            if (disjunction) {
                return Filtration.matchEverything();
            }
            iterator.remove();
        }
        if (arrayList.isEmpty()) {
            if (disjunction) {
                return Filtration.matchNothing();
            }
            return Filtration.matchEverything();
        }
        if (arrayList.size() == 1) {
            return (DimFilter)arrayList.get(0);
        }
        return disjunction ? new OrDimFilter(arrayList) : new AndDimFilter(arrayList);
    }

    private static DimFilter disjunction(List<DimFilter> operands) {
        Preconditions.checkArgument((operands.size() > 0 ? 1 : 0) != 0, (Object)"invalid number of operands");
        if (operands.size() == 1) {
            return operands.get(0);
        }
        return new OrDimFilter(operands);
    }

    private static DimFilter negate(DimFilter filter) {
        if (Filtration.matchEverything().equals(filter)) {
            return Filtration.matchNothing();
        }
        if (Filtration.matchNothing().equals(filter)) {
            return Filtration.matchEverything();
        }
        if (filter instanceof NotDimFilter) {
            return ((NotDimFilter)filter).getField();
        }
        if (filter instanceof BoundDimFilter) {
            BoundDimFilter negated = Bounds.not((BoundDimFilter)filter);
            return negated != null ? negated : new NotDimFilter(filter);
        }
        if (filter instanceof RangeFilter) {
            RangeFilter negated = Ranges.not((RangeFilter)filter);
            return negated != null ? negated : new NotDimFilter(filter);
        }
        return new NotDimFilter(filter);
    }
}

