/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.filtration.BottomUpTransform;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.CollectComparisons;
import org.apache.druid.sql.calcite.filtration.RangeRefKey;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class ConvertSelectorsToIns
extends BottomUpTransform {
    private final RowSignature sourceRowSignature;

    private ConvertSelectorsToIns(RowSignature sourceRowSignature) {
        this.sourceRowSignature = sourceRowSignature;
    }

    public static ConvertSelectorsToIns create(RowSignature sourceRowSignature) {
        return new ConvertSelectorsToIns(sourceRowSignature);
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof OrDimFilter) {
            List<Object> children = Lists.newArrayList((Iterable)((OrDimFilter)filter).getFields());
            children = new CollectSelectors(children, this.sourceRowSignature).collect();
            children = NullHandling.sqlCompatible() ? new CollectEqualities((List<DimFilter>)children).collect() : new CollectEqualitiesDefaultValueMode((List<DimFilter>)children).collect();
            if (!children.equals(((OrDimFilter)filter).getFields())) {
                return children.size() == 1 ? (DimFilter)children.get(0) : new OrDimFilter(children);
            }
            return filter;
        }
        return filter;
    }

    @Nullable
    private static <T extends DimFilter> Pair<T, List<DimFilter>> splitAnd(DimFilter filter, Class<T> filterClass, Comparator<T> preference) {
        if (filter instanceof AndDimFilter) {
            List children = ((AndDimFilter)filter).getFields();
            DimFilter found = null;
            for (DimFilter child : children) {
                if (!filterClass.isAssignableFrom(child.getClass())) continue;
                DimFilter childFilter = (DimFilter)filterClass.cast(child);
                if (found != null && preference.compare(childFilter, found) <= 0) continue;
                found = childFilter;
            }
            if (found == null) {
                return null;
            }
            ArrayList<DimFilter> others = new ArrayList<DimFilter>(children.size() - 1);
            for (DimFilter child : children) {
                if (child == found) continue;
                others.add(child);
            }
            return Pair.of((Object)found, others);
        }
        if (filterClass.isAssignableFrom(filter.getClass())) {
            return Pair.of((Object)((DimFilter)filterClass.cast(filter)), Collections.emptyList());
        }
        return null;
    }

    private static class CollectEqualitiesDefaultValueMode
    extends CollectComparisons<DimFilter, EqualityFilter, InDimFilter, RangeRefKey, String, InDimFilter.ValuesSet> {
        public CollectEqualitiesDefaultValueMode(List<DimFilter> orExprs) {
            super(orExprs);
        }

        @Override
        @Nullable
        protected Pair<EqualityFilter, List<DimFilter>> getCollectibleComparison(DimFilter filter) {
            return ConvertSelectorsToIns.splitAnd(filter, EqualityFilter.class, Comparator.comparing(equality -> equality.getMatchValue() == null ? 0 : 1));
        }

        @Override
        protected InDimFilter.ValuesSet makeCollection() {
            return new InDimFilter.ValuesSet();
        }

        @Override
        @Nullable
        protected RangeRefKey getCollectionKey(EqualityFilter selector) {
            return RangeRefKey.from(selector);
        }

        @Override
        protected Set<String> getMatchValues(EqualityFilter selector) {
            return Collections.singleton(Evals.asString((Object)selector.getMatchValue()));
        }

        @Override
        @Nullable
        protected InDimFilter makeCollectedComparison(RangeRefKey rangeRefKey, InDimFilter.ValuesSet values) {
            if (values.size() > 1) {
                return new InDimFilter(rangeRefKey.getColumn(), values, null, null);
            }
            return null;
        }

        @Override
        protected DimFilter makeAnd(List<DimFilter> exprs) {
            return new AndDimFilter(exprs);
        }
    }

    private static class CollectEqualities
    extends CollectComparisons<DimFilter, EqualityFilter, TypedInFilter, RangeRefKey, Object, List<Object>> {
        public CollectEqualities(List<DimFilter> orExprs) {
            super(orExprs);
        }

        @Override
        @Nullable
        protected Pair<EqualityFilter, List<DimFilter>> getCollectibleComparison(DimFilter filter) {
            return ConvertSelectorsToIns.splitAnd(filter, EqualityFilter.class, Comparator.comparing(equality -> equality.getMatchValue() == null ? 0 : 1));
        }

        @Override
        protected List<Object> makeCollection() {
            return new ArrayList<Object>();
        }

        @Override
        @Nullable
        protected RangeRefKey getCollectionKey(EqualityFilter selector) {
            return RangeRefKey.from(selector);
        }

        @Override
        protected Set<Object> getMatchValues(EqualityFilter selector) {
            return Collections.singleton(selector.getMatchValue());
        }

        @Override
        @Nullable
        protected TypedInFilter makeCollectedComparison(RangeRefKey rangeRefKey, List<Object> values) {
            if (values.size() > 1) {
                return new TypedInFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), values, null, null);
            }
            return null;
        }

        @Override
        protected DimFilter makeAnd(List<DimFilter> exprs) {
            return new AndDimFilter(exprs);
        }
    }

    private static class CollectSelectors
    extends CollectComparisons<DimFilter, SelectorDimFilter, InDimFilter, BoundRefKey, String, InDimFilter.ValuesSet> {
        private final RowSignature sourceRowSignature;

        public CollectSelectors(List<DimFilter> orExprs, RowSignature sourceRowSignature) {
            super(orExprs);
            this.sourceRowSignature = sourceRowSignature;
        }

        @Override
        @Nullable
        protected Pair<SelectorDimFilter, List<DimFilter>> getCollectibleComparison(DimFilter filter) {
            return ConvertSelectorsToIns.splitAnd(filter, SelectorDimFilter.class, Comparator.comparing(selector -> selector.getValue() == null ? 0 : 1));
        }

        @Override
        protected InDimFilter.ValuesSet makeCollection() {
            return new InDimFilter.ValuesSet();
        }

        @Override
        @Nullable
        protected BoundRefKey getCollectionKey(SelectorDimFilter selector) {
            return BoundRefKey.from(selector, RowSignatures.getNaturalStringComparator(this.sourceRowSignature, SimpleExtraction.of(selector.getDimension(), selector.getExtractionFn())));
        }

        @Override
        protected Set<String> getMatchValues(SelectorDimFilter selector) {
            return Collections.singleton(selector.getValue());
        }

        @Override
        @Nullable
        protected InDimFilter makeCollectedComparison(BoundRefKey boundRefKey, InDimFilter.ValuesSet values) {
            if (values.size() > 1) {
                return new InDimFilter(boundRefKey.getDimension(), values, boundRefKey.getExtractionFn(), null);
            }
            return null;
        }

        @Override
        protected DimFilter makeAnd(List<DimFilter> exprs) {
            return new AndDimFilter(exprs);
        }
    }
}

