/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.rel.Projection;

public class Sorting {
    private final List<OrderByColumnSpec> orderBys;
    @Nullable
    private final Projection projection;
    private final OffsetLimit offsetLimit;

    private Sorting(List<OrderByColumnSpec> orderBys, OffsetLimit offsetLimit, @Nullable Projection projection) {
        this.orderBys = (List)Preconditions.checkNotNull(orderBys, (Object)"orderBys");
        this.offsetLimit = offsetLimit;
        this.projection = projection;
    }

    public static Sorting create(List<OrderByColumnSpec> orderBys, OffsetLimit offsetLimit, @Nullable Projection projection) {
        return new Sorting(orderBys, offsetLimit, projection);
    }

    public static Sorting none() {
        return new Sorting(Collections.emptyList(), OffsetLimit.none(), null);
    }

    public SortKind getTimeSortKind(String timeColumn) {
        OrderByColumnSpec orderBy;
        if (this.orderBys.isEmpty()) {
            return SortKind.UNORDERED;
        }
        if (this.orderBys.size() == 1 && (orderBy = (OrderByColumnSpec)Iterables.getOnlyElement(this.orderBys)).getDimension().equals(timeColumn)) {
            return orderBy.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? SortKind.TIME_ASCENDING : SortKind.TIME_DESCENDING;
        }
        return SortKind.NON_TIME;
    }

    public List<OrderByColumnSpec> getOrderBys() {
        return this.orderBys;
    }

    @Nullable
    public Projection getProjection() {
        return this.projection;
    }

    public OffsetLimit getOffsetLimit() {
        return this.offsetLimit;
    }

    public LimitSpec limitSpec() {
        Integer limitAsInteger;
        if (this.orderBys.isEmpty() && !this.offsetLimit.hasOffset() && !this.offsetLimit.hasLimit()) {
            return NoopLimitSpec.instance();
        }
        Integer offsetAsInteger = this.offsetLimit.hasOffset() ? Integer.valueOf(Ints.checkedCast((long)this.offsetLimit.getOffset())) : null;
        Integer n = limitAsInteger = this.offsetLimit.hasLimit() ? Integer.valueOf(Ints.checkedCast((long)this.offsetLimit.getLimit())) : null;
        if (limitAsInteger != null && limitAsInteger == 0) {
            throw new ISE("Cannot create LimitSpec with zero limit", new Object[0]);
        }
        return new DefaultLimitSpec(this.orderBys, offsetAsInteger, limitAsInteger);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sorting sorting = (Sorting)o;
        return Objects.equals(this.orderBys, sorting.orderBys) && Objects.equals(this.projection, sorting.projection) && Objects.equals(this.offsetLimit, sorting.offsetLimit);
    }

    public int hashCode() {
        return Objects.hash(this.orderBys, this.projection, this.offsetLimit);
    }

    public String toString() {
        return "Sorting{orderBys=" + this.orderBys + ", projection=" + this.projection + ", offsetLimit=" + this.offsetLimit + '}';
    }

    static enum SortKind {
        UNORDERED,
        TIME_ASCENDING,
        TIME_DESCENDING,
        NON_TIME;

    }
}

