/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.NaivePartitioningOperatorFactory;
import org.apache.druid.query.operator.NaiveSortOperatorFactory;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.operator.window.WindowFramedAggregateProcessor;
import org.apache.druid.query.operator.window.WindowOperatorFactory;
import org.apache.druid.query.operator.window.ranking.WindowCumeDistProcessor;
import org.apache.druid.query.operator.window.ranking.WindowDenseRankProcessor;
import org.apache.druid.query.operator.window.ranking.WindowPercentileProcessor;
import org.apache.druid.query.operator.window.ranking.WindowRankProcessor;
import org.apache.druid.query.operator.window.ranking.WindowRowNumberProcessor;
import org.apache.druid.query.operator.window.value.WindowFirstProcessor;
import org.apache.druid.query.operator.window.value.WindowLastProcessor;
import org.apache.druid.query.operator.window.value.WindowOffsetProcessor;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.rule.GroupByRules;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class Windowing {
    @VisibleForTesting
    public static final ImmutableMap<String, ProcessorMaker> KNOWN_WINDOW_FNS = ImmutableMap.builder().put((Object)"LAG", agg -> new WindowOffsetProcessor(agg.getColumn(0), agg.getOutputName(), -agg.getConstantInt(1, 1))).put((Object)"LEAD", agg -> new WindowOffsetProcessor(agg.getColumn(0), agg.getOutputName(), agg.getConstantInt(1, 1))).put((Object)"FIRST_VALUE", agg -> new WindowFirstProcessor(agg.getColumn(0), agg.getOutputName())).put((Object)"LAST_VALUE", agg -> new WindowLastProcessor(agg.getColumn(0), agg.getOutputName())).put((Object)"CUME_DIST", agg -> new WindowCumeDistProcessor(agg.getGroup().getOrderingColumNames(), agg.getOutputName())).put((Object)"DENSE_RANK", agg -> new WindowDenseRankProcessor(agg.getGroup().getOrderingColumNames(), agg.getOutputName())).put((Object)"NTILE", agg -> new WindowPercentileProcessor(agg.getOutputName(), agg.getConstantInt(0))).put((Object)"PERCENT_RANK", agg -> new WindowRankProcessor(agg.getGroup().getOrderingColumNames(), agg.getOutputName(), true)).put((Object)"RANK", agg -> new WindowRankProcessor(agg.getGroup().getOrderingColumNames(), agg.getOutputName(), false)).put((Object)"ROW_NUMBER", agg -> new WindowRowNumberProcessor(agg.getOutputName())).build();
    private final List<OperatorFactory> ops;
    private final RowSignature signature;

    @Nonnull
    public static Windowing fromCalciteStuff(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature sourceRowSignature, RexBuilder rexBuilder, VirtualColumnRegistry virtualColumnRegistry) {
        Window window = (Window)Preconditions.checkNotNull((Object)partialQuery.getWindow(), (Object)"window");
        ArrayList<WindowComputationProcessor> windowGroupProcessors = new ArrayList<WindowComputationProcessor>();
        ArrayList<String> windowOutputColumns = new ArrayList<String>(sourceRowSignature.getColumnNames());
        String outputNamePrefix = Calcites.findUnusedPrefixForDigits("w", sourceRowSignature.getColumnNames());
        int outputNameCounter = 0;
        for (Window.Group windowGroup : window.groups) {
            WindowGroup group = new WindowGroup(window, windowGroup, sourceRowSignature);
            List<AggregateCall> aggregateCalls = group.getAggregateCalls();
            ArrayList<Object> processors = new ArrayList<Object>();
            ArrayList<AggregatorFactory> aggregations = new ArrayList<AggregatorFactory>();
            for (AggregateCall aggregateCall : aggregateCalls) {
                String aggName = outputNamePrefix + outputNameCounter++;
                windowOutputColumns.add(aggName);
                ProcessorMaker maker = (ProcessorMaker)KNOWN_WINDOW_FNS.get((Object)aggregateCall.getAggregation().getName());
                if (maker == null) {
                    Aggregation aggregation = GroupByRules.translateAggregateCall(plannerContext, sourceRowSignature, virtualColumnRegistry, rexBuilder, InputAccessor.buildFor((RelNode)window, partialQuery.getSelectProject(), sourceRowSignature), Collections.emptyList(), aggName, aggregateCall, false);
                    if (aggregation == null || aggregation.getPostAggregator() != null || aggregation.getAggregatorFactories().size() != 1) {
                        plannerContext.setPlanningError("Aggregation [%s] is currently not supported for window functions", aggregateCall.getAggregation().getName());
                        throw new CannotBuildQueryException((RelNode)window, aggregateCall);
                    }
                    aggregations.add((AggregatorFactory)Iterables.getOnlyElement(aggregation.getAggregatorFactories()));
                    continue;
                }
                processors.add(maker.make(new WindowAggregate(aggName, aggregateCall, sourceRowSignature, plannerContext, rexBuilder, partialQuery.getSelectProject(), (List)window.constants, group)));
            }
            if (!aggregations.isEmpty()) {
                processors.add(new WindowFramedAggregateProcessor(group.getWindowFrame(), aggregations.toArray(new AggregatorFactory[0])));
            }
            if (processors.isEmpty()) {
                throw new ISE("No processors from Window[%s], why was this code called?", new Object[]{window});
            }
            windowGroupProcessors.add(new WindowComputationProcessor(group, (OperatorFactory)new WindowOperatorFactory((Processor)(processors.size() == 1 ? (Processor)processors.get(0) : new ComposingProcessor(processors.toArray(new Processor[0]))))));
        }
        List<OperatorFactory> ops = Windowing.computeWindowOperations(partialQuery, sourceRowSignature, windowGroupProcessors);
        if (partialQuery.getWindowProject() != null) {
            Preconditions.checkArgument((boolean)partialQuery.getWindowProject().isMapping());
            Mappings.TargetMapping mapping = (Mappings.TargetMapping)Preconditions.checkNotNull((Object)Project.getPartialMapping((int)partialQuery.getWindowProject().getInput().getRowType().getFieldCount(), (List)partialQuery.getWindowProject().getProjects()), (String)"mapping for windowProject[%s]", (Object)partialQuery.getWindowProject());
            ArrayList<String> windowProjectOutputColumns = new ArrayList<String>();
            for (int i = 0; i < mapping.size(); ++i) {
                windowProjectOutputColumns.add((String)windowOutputColumns.get(mapping.getSourceOpt(i)));
            }
            return new Windowing(RowSignatures.fromRelDataType(windowProjectOutputColumns, partialQuery.getWindowProject().getRowType()), ops);
        }
        return new Windowing(RowSignatures.fromRelDataType(windowOutputColumns, window.getRowType()), ops);
    }

    private static List<OperatorFactory> computeWindowOperations(PartialDruidQuery partialQuery, RowSignature sourceRowSignature, List<WindowComputationProcessor> windowGroupProcessors) {
        ArrayList<OperatorFactory> ops = new ArrayList<OperatorFactory>();
        ArrayList<String> priorPartitionColumns = null;
        LinkedHashSet<ColumnWithDirection> priorSortColumns = new LinkedHashSet();
        RelCollation priorCollation = (RelCollation)partialQuery.getScan().getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        if (priorCollation != null) {
            priorSortColumns = Windowing.computeSortColumnsFromRelCollation(priorCollation, sourceRowSignature);
        }
        windowGroupProcessors.sort(WindowComputationProcessor.MOVE_EMPTY_GROUPS_FIRST);
        for (WindowComputationProcessor windowComputationProcessor : windowGroupProcessors) {
            WindowGroup group = windowComputationProcessor.getGroup();
            LinkedHashSet<ColumnWithDirection> sortColumns = new LinkedHashSet<ColumnWithDirection>();
            for (String partitionColumn : group.getPartitionColumns()) {
                sortColumns.add(ColumnWithDirection.ascending((String)partitionColumn));
            }
            sortColumns.addAll(group.getOrdering());
            if (!Windowing.sortMatches(priorSortColumns, sortColumns)) {
                ops.add((OperatorFactory)new NaiveSortOperatorFactory(new ArrayList<ColumnWithDirection>(sortColumns)));
                ops.add((OperatorFactory)new NaivePartitioningOperatorFactory(group.getPartitionColumns()));
                priorSortColumns = sortColumns;
                priorPartitionColumns = group.getPartitionColumns();
            } else if (!group.getPartitionColumns().equals(priorPartitionColumns)) {
                ops.add((OperatorFactory)new NaivePartitioningOperatorFactory(group.getPartitionColumns()));
                priorPartitionColumns = group.getPartitionColumns();
            }
            ops.add(windowComputationProcessor.getProcessorOperatorFactory());
        }
        return ops;
    }

    public Windowing(RowSignature signature, List<OperatorFactory> ops) {
        this.signature = signature;
        this.ops = ops;
    }

    public RowSignature getSignature() {
        return this.signature;
    }

    public List<OperatorFactory> getOperators() {
        return this.ops;
    }

    private static LinkedHashSet<ColumnWithDirection> computeSortColumnsFromRelCollation(RelCollation collation, RowSignature sourceRowSignature) {
        LinkedHashSet<ColumnWithDirection> retVal = new LinkedHashSet<ColumnWithDirection>();
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            ColumnWithDirection.Direction direction;
            switch (fieldCollation.getDirection()) {
                case ASCENDING: 
                case STRICTLY_ASCENDING: {
                    direction = ColumnWithDirection.Direction.ASC;
                    break;
                }
                case DESCENDING: 
                case STRICTLY_DESCENDING: {
                    direction = ColumnWithDirection.Direction.DESC;
                    break;
                }
                default: {
                    return retVal;
                }
            }
            ColumnWithDirection columnWithDirection = new ColumnWithDirection(sourceRowSignature.getColumnName(fieldCollation.getFieldIndex()), direction);
            retVal.add(columnWithDirection);
        }
        return retVal;
    }

    private static boolean sortMatches(Iterable<ColumnWithDirection> priorSort, Iterable<ColumnWithDirection> currentSort) {
        Iterator<ColumnWithDirection> priorIterator = priorSort.iterator();
        for (ColumnWithDirection columnWithDirection : currentSort) {
            if (priorIterator.hasNext() && columnWithDirection.equals((Object)priorIterator.next())) continue;
            return false;
        }
        return true;
    }

    private static class WindowAggregate {
        private final String outputName;
        private final AggregateCall call;
        private final RowSignature sig;
        private final PlannerContext context;
        private final RexBuilder rexBuilder;
        private final Project project;
        private final List<RexLiteral> constants;
        private final WindowGroup group;

        private WindowAggregate(String outputName, AggregateCall call, RowSignature sig, PlannerContext context, RexBuilder rexBuilder, Project project, List<RexLiteral> constants, WindowGroup group) {
            this.outputName = outputName;
            this.call = call;
            this.sig = sig;
            this.context = context;
            this.rexBuilder = rexBuilder;
            this.project = project;
            this.constants = constants;
            this.group = group;
            if (project != null) {
                throw new ISE("Suddenly, the project[%s] is no longer null, the code might need to change.", new Object[]{project});
            }
        }

        public String getOutputName() {
            return this.outputName;
        }

        public WindowGroup getGroup() {
            return this.group;
        }

        public String getColumn(int argPosition) {
            RexNode columnArgument = Expressions.fromFieldAccess(this.rexBuilder.getTypeFactory(), this.sig, this.project, (Integer)this.call.getArgList().get(argPosition));
            DruidExpression expression = Expressions.toDruidExpression(this.context, this.sig, columnArgument);
            if (expression == null) {
                throw new ISE("Couldn't get an expression from columnArgument[%s]", new Object[]{columnArgument});
            }
            return expression.getDirectColumn();
        }

        public RexLiteral getConstantArgument(int argPosition) {
            return this.constants.get((Integer)this.call.getArgList().get(argPosition) - this.sig.size());
        }

        public int getConstantInt(int argPosition) {
            return ((Number)((Object)this.getConstantArgument(argPosition).getValue())).intValue();
        }

        public int getConstantInt(int argPosition, int defaultValue) {
            if (argPosition >= this.call.getArgList().size()) {
                return defaultValue;
            }
            return this.getConstantInt(argPosition);
        }
    }

    private static class WindowGroup {
        private final Window window;
        private final RowSignature sig;
        private final Window.Group group;

        public WindowGroup(Window window, Window.Group group, RowSignature sig) {
            this.window = window;
            this.sig = sig;
            this.group = group;
        }

        public ArrayList<String> getPartitionColumns() {
            ArrayList<String> retVal = new ArrayList<String>();
            Iterator iterator = this.group.keys.iterator();
            while (iterator.hasNext()) {
                int groupKey = (Integer)iterator.next();
                retVal.add(this.sig.getColumnName(groupKey));
            }
            return retVal;
        }

        public ArrayList<ColumnWithDirection> getOrdering() {
            List fields = this.group.orderKeys.getFieldCollations();
            ArrayList<ColumnWithDirection> retVal = new ArrayList<ColumnWithDirection>(fields.size());
            for (RelFieldCollation field : fields) {
                ColumnWithDirection.Direction direction;
                switch (field.direction) {
                    case ASCENDING: {
                        direction = ColumnWithDirection.Direction.ASC;
                        break;
                    }
                    case DESCENDING: {
                        direction = ColumnWithDirection.Direction.DESC;
                        break;
                    }
                    default: {
                        throw new QueryException("SQL query is unsupported", StringUtils.format((String)"Cannot handle ordering with direction[%s]", (Object[])new Object[]{field.direction}), null, null);
                    }
                }
                retVal.add(new ColumnWithDirection(this.sig.getColumnName(field.getFieldIndex()), direction));
            }
            return retVal;
        }

        public ArrayList<String> getOrderingColumNames() {
            ArrayList<ColumnWithDirection> ordering = this.getOrdering();
            ArrayList<String> retVal = new ArrayList<String>(ordering.size());
            for (ColumnWithDirection column : ordering) {
                retVal.add(column.getColumn());
            }
            return retVal;
        }

        public List<AggregateCall> getAggregateCalls() {
            return this.group.getAggregateCalls(this.window);
        }

        public WindowFrame getWindowFrame() {
            if (this.group.lowerBound.isUnbounded() && this.group.upperBound.isUnbounded()) {
                return WindowFrame.unbounded();
            }
            if (this.group.isRows) {
                return WindowFrame.rows((Integer)this.getBoundAsInteger(this.group.lowerBound), (Integer)this.getBoundAsInteger(this.group.upperBound));
            }
            return WindowFrame.groups((Integer)this.getBoundAsInteger(this.group.lowerBound), (Integer)this.getBoundAsInteger(this.group.upperBound), this.getOrderingColumNames());
        }

        private Integer getBoundAsInteger(RexWindowBound bound) {
            if (bound.isUnbounded()) {
                return null;
            }
            if (bound.isCurrentRow()) {
                return 0;
            }
            int value = this.getConstant(((RexInputRef)bound.getOffset()).getIndex());
            return bound.isPreceding() ? -value : value;
        }

        private int getConstant(int refIndex) {
            return ((Number)((Object)((RexLiteral)this.window.constants.get(refIndex - this.sig.size())).getValue())).intValue();
        }
    }

    private static interface ProcessorMaker {
        public Processor make(WindowAggregate var1);
    }

    private static class WindowComputationProcessor {
        private final WindowGroup group;
        private final OperatorFactory processorOperatorFactory;
        public static final Comparator<WindowComputationProcessor> MOVE_EMPTY_GROUPS_FIRST = (o1, o2) -> {
            if (o1.getGroup().getPartitionColumns().isEmpty() && o2.getGroup().getPartitionColumns().isEmpty()) {
                return 0;
            }
            if (o1.getGroup().getPartitionColumns().isEmpty()) {
                return -1;
            }
            if (o2.getGroup().getPartitionColumns().isEmpty()) {
                return 1;
            }
            return 0;
        };

        public WindowComputationProcessor(WindowGroup group, OperatorFactory processorOperatorFactory) {
            this.group = group;
            this.processorOperatorFactory = processorOperatorFactory;
        }

        public WindowGroup getGroup() {
            return this.group;
        }

        public OperatorFactory getProcessorOperatorFactory() {
            return this.processorOperatorFactory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WindowComputationProcessor obj = (WindowComputationProcessor)o;
            return Objects.equals(this.group, obj.group) && Objects.equals(this.processorOperatorFactory, obj.processorOperatorFactory);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.processorOperatorFactory);
        }
    }
}

