/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;

public class DruidSort
extends Sort
implements DruidLogicalNode {
    private DruidSort(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traits, input, collation, offset, fetch);
        assert (this.getConvention() instanceof DruidLogicalConvention);
    }

    public static DruidSort create(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        collation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)collation);
        RelTraitSet traitSet = input.getTraitSet().replace((RelTrait)DruidLogicalConvention.instance()).replace((RelTrait)collation);
        return new DruidSort(cluster, traitSet, input, collation, offset, fetch);
    }

    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new DruidSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost = 0.0;
        double rowCount = mq.getRowCount((RelNode)this);
        if (this.fetch != null) {
            OffsetLimit offsetLimit = OffsetLimit.fromSort(this);
            rowCount = Math.min(rowCount, (double)(offsetLimit.getLimit() - offsetLimit.getOffset()));
        }
        if (!this.getCollation().getFieldCollations().isEmpty() && this.fetch == null) {
            cost = rowCount * 10.0;
        }
        return planner.getCostFactory().makeCost(rowCount, cost, 0.0);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("druid", (Object)"logical");
    }
}

