/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;

public class DruidUnion
extends Union
implements DruidLogicalNode,
SourceDescProducer {
    public DruidUnion(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, List<RelNode> inputs, boolean all) {
        super(cluster, traits, hints, inputs, all);
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new DruidUnion(this.getCluster(), traitSet, (List<RelHint>)this.hints, inputs, all);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(mq.getRowCount((RelNode)this).doubleValue(), 0.0, 0.0);
    }

    @Override
    public SourceDescProducer.SourceDesc getSourceDesc(PlannerContext plannerContext, List<SourceDescProducer.SourceDesc> sources) {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        RowSignature signature = null;
        for (SourceDescProducer.SourceDesc sourceDesc : sources) {
            this.checkDataSourceSupported(sourceDesc.dataSource);
            dataSources.add(sourceDesc.dataSource);
            if (signature == null) {
                signature = sourceDesc.rowSignature;
                continue;
            }
            if (signature.equals((Object)sourceDesc.rowSignature)) continue;
            throw DruidException.defensive((String)"Row signature mismatch in Union inputs [%s] and [%s]", (Object[])new Object[]{signature, sourceDesc.rowSignature});
        }
        return new SourceDescProducer.SourceDesc((DataSource)new UnionDataSource(dataSources), signature);
    }

    private void checkDataSourceSupported(DataSource dataSource) {
        if (dataSource instanceof TableDataSource || dataSource instanceof InlineDataSource) {
            return;
        }
        throw DruidException.defensive((String)"Only Table and Values are supported as inputs for Union [%s]", (Object[])new Object[]{dataSource});
    }
}

