/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.rule.DruidLogicalValuesRule;
import org.apache.druid.sql.calcite.table.InlineTable;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidValues
extends LogicalValues
implements DruidLogicalNode,
SourceDescProducer {
    private InlineTable inlineTable;

    public DruidValues(RelOptCluster cluster, RelTraitSet traitSet, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        super(cluster, traitSet, rowType, tuples);
        assert (this.getConvention() instanceof DruidLogicalConvention);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidValues(this.getCluster(), traitSet, this.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)this.tuples);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(1.0, 0.0, 0.0);
    }

    @Override
    public SourceDescProducer.SourceDesc getSourceDesc(PlannerContext plannerContext, List<SourceDescProducer.SourceDesc> sources) {
        if (this.inlineTable == null) {
            this.inlineTable = this.buildInlineTable(plannerContext);
        }
        return new SourceDescProducer.SourceDesc(this.inlineTable.getDataSource(), this.inlineTable.getRowSignature());
    }

    private InlineTable buildInlineTable(PlannerContext plannerContext) {
        ImmutableList tuples = this.getTuples();
        List objectTuples = tuples.stream().map(tuple -> tuple.stream().map(v -> DruidLogicalValuesRule.getValueFromLiteral(v, plannerContext)).collect(Collectors.toList()).toArray(new Object[0])).collect(Collectors.toList());
        RowSignature rowSignature = RowSignatures.fromRelDataType(this.getRowType().getFieldNames(), this.getRowType());
        InlineTable inlineTable = new InlineTable(InlineDataSource.fromIterable(objectTuples, (RowSignature)rowSignature));
        return inlineTable;
    }
}

