/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.sql.calcite.rule.FlattenConcatRule;

public class FilterDecomposeConcatRule
extends RelOptRule
implements SubstitutionRule {
    public FilterDecomposeConcatRule() {
        super(FilterDecomposeConcatRule.operand(Filter.class, (RelOptRuleOperandChildren)FilterDecomposeConcatRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        Filter oldFilter = (Filter)call.rel(0);
        DecomposeConcatShuttle shuttle = new DecomposeConcatShuttle(oldFilter.getCluster().getRexBuilder());
        RexNode newCondition = (RexNode)oldFilter.getCondition().accept((RexVisitor)shuttle);
        if (newCondition != oldFilter.getCondition()) {
            call.transformTo(call.builder().push(oldFilter.getInput()).filter(new RexNode[]{newCondition}).build());
            call.getPlanner().prune((RelNode)oldFilter);
        }
    }

    @Nullable
    private static RexNode tryDecomposeConcatEquals(RexCall concatCall, RexNode matchRexNode, RexBuilder rexBuilder) {
        String matchValue = FilterDecomposeConcatRule.getAsString(matchRexNode);
        if (matchValue == null) {
            return null;
        }
        StringBuilder regexBuilder = new StringBuilder();
        ArrayList<RexNode> nonLiterals = new ArrayList<RexNode>();
        LinkedHashMultiset literalCounter = LinkedHashMultiset.create();
        boolean expectLiteral = false;
        for (int i = 0; i < concatCall.getOperands().size(); ++i) {
            RexNode operand = (RexNode)concatCall.getOperands().get(i);
            if (RexUtil.isLiteral((RexNode)operand, (boolean)true)) {
                String operandValue = FilterDecomposeConcatRule.getAsString(operand);
                if (operandValue == null || operandValue.isEmpty()) {
                    return null;
                }
                regexBuilder.append(Pattern.quote(operandValue));
                literalCounter.add((Object)operandValue);
                expectLiteral = false;
                continue;
            }
            if (expectLiteral) {
                return null;
            }
            nonLiterals.add(operand);
            regexBuilder.append("(.*)");
            expectLiteral = true;
        }
        int checkPos = 0;
        for (Multiset.Entry entry : literalCounter.entrySet()) {
            int occurrences = FilterDecomposeConcatRule.countOccurrences(matchValue.substring(checkPos), (String)entry.getElement());
            if (occurrences > entry.getCount()) {
                return null;
            }
            if (occurrences < entry.getCount()) {
                return FilterDecomposeConcatRule.impossibleMatch(nonLiterals, rexBuilder);
            }
            checkPos = matchValue.indexOf((String)entry.getElement()) + 1;
        }
        Pattern regex = Pattern.compile(regexBuilder.toString(), 32);
        Matcher matcher = regex.matcher(matchValue);
        if (matcher.matches()) {
            ArrayList<RexNode> conditions = new ArrayList<RexNode>(nonLiterals.size());
            for (int i = 0; i < nonLiterals.size(); ++i) {
                RexNode operand = (RexNode)nonLiterals.get(i);
                conditions.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{operand, rexBuilder.makeLiteral(matcher.group(i + 1))}));
            }
            return RexUtil.composeConjunction((RexBuilder)rexBuilder, conditions);
        }
        return FilterDecomposeConcatRule.impossibleMatch(nonLiterals, rexBuilder);
    }

    private static RexNode impossibleMatch(List<RexNode> nonLiterals, RexBuilder rexBuilder) {
        if (NullHandling.sqlCompatible()) {
            RexLiteral unknown = rexBuilder.makeNullLiteral(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN));
            return RexUtil.composeDisjunction((RexBuilder)rexBuilder, (Iterable)Iterables.transform(nonLiterals, operand -> rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{operand}), unknown})));
        }
        return rexBuilder.makeLiteral(false);
    }

    @Nullable
    private static String getAsString(RexNode rexNode) {
        if (!SqlTypeFamily.STRING.contains(rexNode.getType())) {
            return null;
        }
        RexNode matchLiteral = RexUtil.removeCast((RexNode)rexNode);
        if (SqlTypeFamily.STRING.contains(matchLiteral.getType())) {
            return RexLiteral.stringValue((RexNode)matchLiteral);
        }
        if (SqlTypeFamily.NUMERIC.contains(matchLiteral.getType())) {
            return String.valueOf(RexLiteral.value((RexNode)matchLiteral));
        }
        return null;
    }

    private static int countOccurrences(String string, String substring) {
        int count = 0;
        int i = -1;
        while ((i = string.indexOf(substring, i + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    static class DecomposeConcatShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        DecomposeConcatShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            RexNode newCall;
            boolean negate;
            if (call.isA(SqlKind.EQUALS) || call.isA(SqlKind.NOT_EQUALS)) {
                negate = call.isA(SqlKind.NOT_EQUALS);
                RexNode lhs = (RexNode)call.getOperands().get(0);
                RexNode rhs = (RexNode)call.getOperands().get(1);
                newCall = FlattenConcatRule.isNonTrivialStringConcat(lhs) && RexUtil.isLiteral((RexNode)rhs, (boolean)true) ? FilterDecomposeConcatRule.tryDecomposeConcatEquals((RexCall)lhs, rhs, this.rexBuilder) : (FlattenConcatRule.isNonTrivialStringConcat(rhs) && RexUtil.isLiteral((RexNode)lhs, (boolean)true) ? FilterDecomposeConcatRule.tryDecomposeConcatEquals((RexCall)rhs, lhs, this.rexBuilder) : null);
            } else if ((call.isA(SqlKind.IS_NULL) || call.isA(SqlKind.IS_NOT_NULL)) && FlattenConcatRule.isNonTrivialStringConcat((RexNode)Iterables.getOnlyElement((Iterable)call.getOperands()))) {
                negate = call.isA(SqlKind.IS_NOT_NULL);
                RexCall concatCall = (RexCall)Iterables.getOnlyElement((Iterable)call.getOperands());
                newCall = NullHandling.sqlCompatible() ? RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, (Iterable)Iterables.transform((Iterable)concatCall.getOperands(), operand -> this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{operand}))) : FilterDecomposeConcatRule.tryDecomposeConcatEquals(concatCall, (RexNode)this.rexBuilder.makeLiteral(""), this.rexBuilder);
            } else {
                negate = false;
                newCall = null;
            }
            if (newCall != null) {
                return negate ? this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{newCall}) : newCall;
            }
            return super.visitCall(call);
        }
    }
}

