/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class InformationSchema
extends AbstractSchema {
    private static final EmittingLogger log = new EmittingLogger(InformationSchema.class);
    private static final String CATALOG_NAME = "druid";
    private static final String INFORMATION_SCHEMA_NAME = "INFORMATION_SCHEMA";
    private static final String SCHEMATA_TABLE = "SCHEMATA";
    private static final String TABLES_TABLE = "TABLES";
    private static final String COLUMNS_TABLE = "COLUMNS";
    private static final String ROUTINES_TABLE = "ROUTINES";
    private static final RelDataType SCHEMATA_SIGNATURE = new RowTypeBuilder().add("CATALOG_NAME", SqlTypeName.VARCHAR).add("SCHEMA_NAME", SqlTypeName.VARCHAR).add("SCHEMA_OWNER", SqlTypeName.VARCHAR).add("DEFAULT_CHARACTER_SET_CATALOG", SqlTypeName.VARCHAR).add("DEFAULT_CHARACTER_SET_SCHEMA", SqlTypeName.VARCHAR).add("DEFAULT_CHARACTER_SET_NAME", SqlTypeName.VARCHAR).add("SQL_PATH", SqlTypeName.VARCHAR).build();
    private static final RelDataType TABLES_SIGNATURE = new RowTypeBuilder().add("TABLE_CATALOG", SqlTypeName.VARCHAR).add("TABLE_SCHEMA", SqlTypeName.VARCHAR).add("TABLE_NAME", SqlTypeName.VARCHAR).add("TABLE_TYPE", SqlTypeName.VARCHAR).add("IS_JOINABLE", SqlTypeName.VARCHAR).add("IS_BROADCAST", SqlTypeName.VARCHAR).build();
    private static final RelDataType COLUMNS_SIGNATURE = new RowTypeBuilder().add("TABLE_CATALOG", SqlTypeName.VARCHAR).add("TABLE_SCHEMA", SqlTypeName.VARCHAR).add("TABLE_NAME", SqlTypeName.VARCHAR).add("COLUMN_NAME", SqlTypeName.VARCHAR).add("ORDINAL_POSITION", SqlTypeName.BIGINT).add("COLUMN_DEFAULT", SqlTypeName.VARCHAR).add("IS_NULLABLE", SqlTypeName.VARCHAR).add("DATA_TYPE", SqlTypeName.VARCHAR).add("CHARACTER_MAXIMUM_LENGTH", SqlTypeName.VARCHAR, true).add("CHARACTER_OCTET_LENGTH", SqlTypeName.VARCHAR, true).add("NUMERIC_PRECISION", SqlTypeName.BIGINT, true).add("NUMERIC_PRECISION_RADIX", SqlTypeName.BIGINT, true).add("NUMERIC_SCALE", SqlTypeName.BIGINT, true).add("DATETIME_PRECISION", SqlTypeName.BIGINT, true).add("CHARACTER_SET_NAME", SqlTypeName.VARCHAR, true).add("COLLATION_NAME", SqlTypeName.VARCHAR, true).add("JDBC_TYPE", SqlTypeName.BIGINT).build();
    private static final RelDataType ROUTINES_SIGNATURE = new RowTypeBuilder().add("ROUTINE_CATALOG", SqlTypeName.VARCHAR).add("ROUTINE_SCHEMA", SqlTypeName.VARCHAR).add("ROUTINE_NAME", SqlTypeName.VARCHAR).add("ROUTINE_TYPE", SqlTypeName.VARCHAR).add("IS_AGGREGATOR", SqlTypeName.VARCHAR).add("SIGNATURES", SqlTypeName.VARCHAR, true).build();
    private static final RelDataTypeSystem TYPE_SYSTEM = RelDataTypeSystem.DEFAULT;
    private static final String INFO_TRUE = "YES";
    private static final String INFO_FALSE = "NO";
    private final DruidSchemaCatalog rootSchema;
    private final Map<String, Table> tableMap;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public InformationSchema(@Named(value="INCOMPLETE_SCHEMA") DruidSchemaCatalog rootSchema, AuthorizerMapper authorizerMapper, DruidOperatorTable operatorTable) {
        this.rootSchema = (DruidSchemaCatalog)Preconditions.checkNotNull((Object)rootSchema, (Object)"rootSchema");
        this.tableMap = ImmutableMap.of((Object)SCHEMATA_TABLE, (Object)((Object)new SchemataTable()), (Object)TABLES_TABLE, (Object)((Object)new TablesTable()), (Object)COLUMNS_TABLE, (Object)((Object)new ColumnsTable()), (Object)ROUTINES_TABLE, (Object)((Object)new RoutinesTable(operatorTable)));
        this.authorizerMapper = authorizerMapper;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    @Nullable
    private static TableMacro getView(SchemaPlus schemaPlus, String functionName) {
        Collection functions = schemaPlus.getFunctions(functionName);
        for (org.apache.calcite.schema.Function function : functions) {
            if (!function.getParameters().isEmpty() || !(function instanceof TableMacro)) continue;
            return (TableMacro)function;
        }
        return null;
    }

    private Set<String> getAuthorizedTableNamesFromSubSchema(SchemaPlus subSchema, AuthenticationResult authenticationResult) {
        return this.getAuthorizedNamesFromNamedSchema(authenticationResult, this.rootSchema.getNamedSchema(subSchema.getName()), subSchema.getTableNames());
    }

    private Set<String> getAuthorizedFunctionNamesFromSubSchema(SchemaPlus subSchema, AuthenticationResult authenticationResult) {
        return this.getAuthorizedNamesFromNamedSchema(authenticationResult, this.rootSchema.getNamedSchema(subSchema.getName()), subSchema.getFunctionNames());
    }

    private Set<String> getAuthorizedNamesFromNamedSchema(AuthenticationResult authenticationResult, NamedSchema schema, Set<String> names) {
        if (schema == null) {
            return names;
        }
        return ImmutableSet.copyOf((Iterable)AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, names, name -> {
            String resourseType = schema.getSchemaResourceType((String)name);
            if (resourseType == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new ResourceAction(new Resource(name, resourseType), Action.READ));
        }, (AuthorizerMapper)this.authorizerMapper));
    }

    static class RoutinesTable
    extends AbstractTable
    implements ScannableTable {
        private static final String FUNCTION = "FUNCTION";
        private final DruidOperatorTable operatorTable;

        public RoutinesTable(DruidOperatorTable operatorTable) {
            this.operatorTable = operatorTable;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ROUTINES_SIGNATURE;
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            List<SqlOperator> operatorList = this.operatorTable.getOperatorList();
            for (SqlOperator sqlOperator : operatorList) {
                if (!DruidOperatorTable.isFunctionSyntax(sqlOperator.getSyntax())) continue;
                Object[] row = new Object[]{InformationSchema.CATALOG_NAME, InformationSchema.INFORMATION_SCHEMA_NAME, sqlOperator.getName(), FUNCTION, sqlOperator.isAggregator() ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE, sqlOperator.getOperandTypeChecker() == null ? null : sqlOperator.getAllowedSignatures()};
                rows.add(row);
            }
            return Linq4j.asEnumerable(rows);
        }
    }

    class ColumnsTable
    extends AbstractTable
    implements ScannableTable {
        ColumnsTable() {
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            FluentIterable results = FluentIterable.from(InformationSchema.this.rootSchema.getSubSchemaNames()).transformAndConcat((Function)new Function<String, Iterable<Object[]>>(){

                public Iterable<Object[]> apply(final String schemaName) {
                    final SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    JavaTypeFactory typeFactory = root.getTypeFactory();
                    AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
                    Set authorizedTableNames = InformationSchema.this.getAuthorizedTableNamesFromSubSchema(subSchema, authenticationResult);
                    Set authorizedFunctionNames = InformationSchema.this.getAuthorizedFunctionNamesFromSubSchema(subSchema, authenticationResult);
                    return Iterables.concat((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)FluentIterable.from((Iterable)authorizedTableNames).transform((Function)new Function<String, Iterable<Object[]>>((RelDataTypeFactory)typeFactory){
                        final /* synthetic */ RelDataTypeFactory val$typeFactory;
                        {
                            this.val$typeFactory = relDataTypeFactory;
                        }

                        public Iterable<Object[]> apply(String tableName) {
                            Table table = subSchema.getTable(tableName);
                            if (table == null) {
                                return null;
                            }
                            return ColumnsTable.this.generateColumnMetadata(schemaName, tableName, table.getRowType(this.val$typeFactory), this.val$typeFactory);
                        }
                    }), (Iterable)FluentIterable.from((Iterable)authorizedFunctionNames).transform((Function)new Function<String, Iterable<Object[]>>((RelDataTypeFactory)typeFactory){
                        final /* synthetic */ RelDataTypeFactory val$typeFactory;
                        {
                            this.val$typeFactory = relDataTypeFactory;
                        }

                        public Iterable<Object[]> apply(String functionName) {
                            TableMacro viewMacro = InformationSchema.getView(subSchema, functionName);
                            if (viewMacro != null) {
                                try {
                                    return ColumnsTable.this.generateColumnMetadata(schemaName, functionName, viewMacro.apply(Collections.emptyList()).getRowType(this.val$typeFactory), this.val$typeFactory);
                                }
                                catch (Exception e) {
                                    log.error((Throwable)e, "Encountered exception while handling view[%s].", new Object[]{functionName});
                                    return null;
                                }
                            }
                            return null;
                        }
                    })), (Predicate)Predicates.notNull()));
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return COLUMNS_SIGNATURE;
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        @Nullable
        private Iterable<Object[]> generateColumnMetadata(final String schemaName, final String tableName, RelDataType tableSchema, RelDataTypeFactory typeFactory) {
            return FluentIterable.from((Iterable)tableSchema.getFieldList()).transform((Function)new Function<RelDataTypeField, Object[]>(){

                public Object[] apply(RelDataTypeField field) {
                    RelDataType type = field.getType();
                    SqlTypeName sqlTypeName = type.getSqlTypeName();
                    boolean isNumeric = SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName);
                    boolean isCharacter = SqlTypeName.CHAR_TYPES.contains(sqlTypeName);
                    boolean isDateTime = SqlTypeName.DATETIME_TYPES.contains(sqlTypeName);
                    String typeName = type instanceof RowSignatures.ComplexSqlType ? ((RowSignatures.ComplexSqlType)type).asTypeString() : sqlTypeName.toString();
                    return new Object[]{InformationSchema.CATALOG_NAME, schemaName, tableName, field.getName(), (long)(field.getIndex() + 1), "", type.isNullable() ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE, typeName, null, null, isNumeric ? Long.valueOf(type.getPrecision()) : null, isNumeric ? Long.valueOf(10L) : null, isNumeric ? Long.valueOf(type.getScale()) : null, isDateTime ? Long.valueOf(type.getPrecision()) : null, isCharacter ? type.getCharset().name() : null, isCharacter ? type.getCollation().getCollationName() : null, (long)type.getSqlTypeName().getJdbcOrdinal()};
                }
            });
        }
    }

    class TablesTable
    extends AbstractTable
    implements ScannableTable {
        TablesTable() {
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            FluentIterable results = FluentIterable.from(InformationSchema.this.rootSchema.getSubSchemaNames()).transformAndConcat((Function)new Function<String, Iterable<Object[]>>(){

                public Iterable<Object[]> apply(final String schemaName) {
                    final SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
                    Set authorizedTableNames = InformationSchema.this.getAuthorizedTableNamesFromSubSchema(subSchema, authenticationResult);
                    Set authorizedFunctionNames = InformationSchema.this.getAuthorizedFunctionNamesFromSubSchema(subSchema, authenticationResult);
                    return Iterables.filter((Iterable)Iterables.concat((Iterable)FluentIterable.from((Iterable)authorizedTableNames).transform(tableName -> {
                        boolean isBroadcast;
                        boolean isJoinable;
                        Table table = subSchema.getTable(tableName);
                        if (table instanceof DruidTable) {
                            DruidTable druidTable = (DruidTable)table;
                            isJoinable = druidTable.isJoinable();
                            isBroadcast = druidTable.isBroadcast();
                        } else {
                            isJoinable = false;
                            isBroadcast = false;
                        }
                        return new Object[]{InformationSchema.CATALOG_NAME, schemaName, tableName, table.getJdbcTableType().toString(), isJoinable ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE, isBroadcast ? InformationSchema.INFO_TRUE : InformationSchema.INFO_FALSE};
                    }), (Iterable)FluentIterable.from((Iterable)authorizedFunctionNames).transform((Function)new Function<String, Object[]>(){

                        public Object[] apply(String functionName) {
                            if (InformationSchema.getView(subSchema, functionName) != null) {
                                return new Object[]{InformationSchema.CATALOG_NAME, schemaName, functionName, "VIEW", InformationSchema.INFO_FALSE, InformationSchema.INFO_FALSE};
                            }
                            return null;
                        }
                    })), (Predicate)Predicates.notNull());
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return TABLES_SIGNATURE;
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }
    }

    class SchemataTable
    extends AbstractTable
    implements ScannableTable {
        SchemataTable() {
        }

        public Enumerable<Object[]> scan(DataContext root) {
            FluentIterable results = FluentIterable.from(InformationSchema.this.rootSchema.getSubSchemaNames()).transform((Function)new Function<String, Object[]>(){

                public Object[] apply(String schemaName) {
                    SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    return new Object[]{InformationSchema.CATALOG_NAME, subSchema.getName(), null, null, null, null, null};
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SCHEMATA_SIGNATURE;
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }
    }

    private static class RowTypeBuilder {
        final RelDataTypeFactory typeFactory = DruidTypeSystem.TYPE_FACTORY;
        final RelDataTypeFactory.Builder builder = this.typeFactory.builder();

        private RowTypeBuilder() {
        }

        public RowTypeBuilder add(String name, SqlTypeName type) {
            this.builder.add(name, Calcites.createSqlTypeWithNullability(this.typeFactory, type, false));
            return this;
        }

        public RowTypeBuilder add(String name, SqlTypeName type, boolean nullable) {
            this.builder.add(name, Calcites.createSqlTypeWithNullability(this.typeFactory, type, nullable));
            return this;
        }

        public RelDataType build() {
            return this.builder.build();
        }
    }
}

